/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.List;
import java.util.SortedSet;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.TableBasedReplicationQueuesClientImpl;
import org.apache.hadoop.hbase.replication.TableBasedReplicationQueuesImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationStateHBaseImpl {
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static ZooKeeperWatcher zkw;
    private static String replicationZNode;
    private static ReplicationQueues rq1;
    private static ReplicationQueues rq2;
    private static ReplicationQueues rq3;
    private static ReplicationQueuesClient rqc;
    private static ReplicationPeers rp;
    private static final String server0;
    private static final String server1;
    private static final String server2;
    private static final String server3;
    private static DummyServer ds0;
    private static DummyServer ds1;
    private static DummyServer ds2;
    private static DummyServer ds3;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        utility = new HBaseTestingUtility();
        conf = utility.getConfiguration();
        conf.setClass("hbase.region.replica.replication.replicationQueues.class", TableBasedReplicationQueuesImpl.class, ReplicationQueues.class);
        conf.setClass("hbase.region.replica.replication.replicationQueuesClient.class", TableBasedReplicationQueuesClientImpl.class, ReplicationQueuesClient.class);
        utility.startMiniCluster();
        zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        replicationZNode = ZKUtil.joinZNode((String)TestReplicationStateHBaseImpl.zkw.znodePaths.baseZNode, (String)replicationZNodeName);
    }

    @Before
    public void setUp() {
        try {
            ds0 = new DummyServer(server0);
            rqc = ReplicationFactory.getReplicationQueuesClient((ReplicationQueuesClientArguments)new ReplicationQueuesClientArguments(conf, (Abortable)ds0));
            ds1 = new DummyServer(server1);
            rq1 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)ds1, zkw));
            rq1.init(server1);
            ds2 = new DummyServer(server2);
            rq2 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)ds2, zkw));
            rq2.init(server2);
            ds3 = new DummyServer(server3);
            rq3 = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)ds3, zkw));
            rq3.init(server3);
            rp = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)zkw, (Configuration)conf, (Abortable)zkw);
            rp.init();
        }
        catch (Exception e) {
            Assert.fail((String)("testReplicationStateHBaseConstruction received an exception" + e.getMessage()));
        }
    }

    @Test
    public void checkNamingSchema() throws Exception {
        Assert.assertTrue((boolean)rq1.isThisOurRegionServer(server1));
        Assert.assertTrue((!rq1.isThisOurRegionServer(server1 + "a") ? 1 : 0) != 0);
        Assert.assertTrue((!rq1.isThisOurRegionServer(null) ? 1 : 0) != 0);
    }

    @Test
    public void testSingleReplicationQueuesHBaseImpl() {
        try {
            Assert.assertEquals((long)0L, (long)rq1.getAllQueues().size());
            rq1.addLog("Queue1", "WALLogFile1.1");
            Assert.assertEquals((long)1L, (long)rq1.getAllQueues().size());
            rq1.addLog("Queue1", "WALLogFile1.2");
            rq1.addLog("Queue1", "WALLogFile1.3");
            rq1.addLog("Queue1", "WALLogFile1.4");
            rq1.addLog("Queue2", "WALLogFile2.1");
            rq1.addLog("Queue3", "WALLogFile3.1");
            Assert.assertEquals((long)3L, (long)rq1.getAllQueues().size());
            Assert.assertEquals((long)4L, (long)rq1.getLogsInQueue("Queue1").size());
            Assert.assertEquals((long)1L, (long)rq1.getLogsInQueue("Queue2").size());
            Assert.assertEquals((long)1L, (long)rq1.getLogsInQueue("Queue3").size());
            Assert.assertEquals((long)0L, (long)ds1.getAbortCount());
            TestCase.assertNull((Object)rq1.getLogsInQueue("Queue4"));
            Assert.assertEquals((long)1L, (long)ds1.getAbortCount());
        }
        catch (ReplicationException e) {
            e.printStackTrace();
            Assert.fail((String)"testAddLog received a ReplicationException");
        }
        try {
            Assert.assertEquals((long)0L, (long)rq1.getLogPosition("Queue1", "WALLogFile1.1"));
            rq1.setLogPosition("Queue1", "WALLogFile1.1", 123L);
            Assert.assertEquals((long)123L, (long)rq1.getLogPosition("Queue1", "WALLogFile1.1"));
            rq1.setLogPosition("Queue1", "WALLogFile1.1", 123456789L);
            Assert.assertEquals((long)123456789L, (long)rq1.getLogPosition("Queue1", "WALLogFile1.1"));
            rq1.setLogPosition("Queue2", "WALLogFile2.1", 242L);
            Assert.assertEquals((long)242L, (long)rq1.getLogPosition("Queue2", "WALLogFile2.1"));
            rq1.setLogPosition("Queue3", "WALLogFile3.1", 243L);
            Assert.assertEquals((long)243L, (long)rq1.getLogPosition("Queue3", "WALLogFile3.1"));
            Assert.assertEquals((long)1L, (long)ds1.getAbortCount());
            rq1.setLogPosition("NotHereQueue", "WALLogFile3.1", 243L);
            Assert.assertEquals((long)2L, (long)ds1.getAbortCount());
            rq1.setLogPosition("NotHereQueue", "NotHereFile", 243L);
            Assert.assertEquals((long)3L, (long)ds1.getAbortCount());
            rq1.setLogPosition("Queue1", "NotHereFile", 243L);
            Assert.assertEquals((long)4L, (long)ds1.getAbortCount());
            try {
                rq1.getLogPosition("Queue1", "NotHereWAL");
                Assert.fail((String)"Replication queue should have thrown a ReplicationException for reading from a non-existent WAL");
            }
            catch (ReplicationException e) {
                // empty catch block
            }
            try {
                rq1.getLogPosition("NotHereQueue", "NotHereWAL");
                Assert.fail((String)"Replication queue should have thrown a ReplicationException for reading from a non-existent queue");
            }
            catch (ReplicationException e) {
                // empty catch block
            }
            rq1.removeLog("Queue1", "WALLogFile1.1");
            Assert.assertEquals((long)3L, (long)rq1.getLogsInQueue("Queue1").size());
            rq1.removeQueue("Queue2");
            Assert.assertEquals((long)2L, (long)rq1.getAllQueues().size());
            TestCase.assertNull((Object)rq1.getLogsInQueue("Queue2"));
            Assert.assertEquals((long)5L, (long)ds1.getAbortCount());
            rq1.removeAllQueues();
            Assert.assertEquals((long)0L, (long)rq1.getAllQueues().size());
            TestCase.assertNull((Object)rq1.getLogsInQueue("Queue1"));
            Assert.assertEquals((long)6L, (long)ds1.getAbortCount());
            rq1.removeQueue("NotHereQueue");
            Assert.assertEquals((long)6L, (long)ds1.getAbortCount());
        }
        catch (ReplicationException e) {
            e.printStackTrace();
            Assert.fail((String)"testAddLog received a ReplicationException");
        }
    }

    @Test
    public void TestMultipleReplicationQueuesHBaseImpl() {
        try {
            rp.registerPeer("Queue1", new ReplicationPeerConfig().setClusterKey("localhost:2818:/bogus1"));
            rp.registerPeer("Queue2", new ReplicationPeerConfig().setClusterKey("localhost:2818:/bogus2"));
            rp.registerPeer("Queue3", new ReplicationPeerConfig().setClusterKey("localhost:2818:/bogus3"));
        }
        catch (ReplicationException e) {
            Assert.fail((String)"Failed to add peers to ReplicationPeers");
        }
        try {
            rq1.addLog("Queue1", "WALLogFile1.1");
            rq1.addLog("Queue1", "WALLogFile1.2");
            rq1.addLog("Queue1", "WALLogFile1.3");
            rq1.addLog("Queue1", "WALLogFile1.4");
            rq1.addLog("Queue2", "WALLogFile2.1");
            rq1.addLog("Queue3", "WALLogFile3.1");
            rq2.addLog("Queue1", "WALLogFile1.1");
            rq2.addLog("Queue1", "WALLogFile1.2");
            rq2.addLog("Queue2", "WALLogFile2.1");
            rq3.addLog("Queue1", "WALLogFile1.1");
            Assert.assertEquals((long)3L, (long)rq1.getAllQueues().size());
            Assert.assertEquals((long)2L, (long)rq2.getAllQueues().size());
            Assert.assertEquals((long)1L, (long)rq3.getAllQueues().size());
            Assert.assertEquals((long)4L, (long)rq1.getLogsInQueue("Queue1").size());
            Assert.assertEquals((long)1L, (long)rq1.getLogsInQueue("Queue2").size());
            Assert.assertEquals((long)1L, (long)rq1.getLogsInQueue("Queue3").size());
            Assert.assertEquals((long)2L, (long)rq2.getLogsInQueue("Queue1").size());
            Assert.assertEquals((long)1L, (long)rq2.getLogsInQueue("Queue2").size());
            Assert.assertEquals((long)1L, (long)rq3.getLogsInQueue("Queue1").size());
        }
        catch (ReplicationException e) {
            e.printStackTrace();
            Assert.fail((String)"testAddLogs received a ReplicationException");
        }
        try {
            rq1.setLogPosition("Queue1", "WALLogFile1.1", 1L);
            rq1.setLogPosition("Queue1", "WALLogFile1.2", 2L);
            rq1.setLogPosition("Queue1", "WALLogFile1.3", 3L);
            rq1.setLogPosition("Queue2", "WALLogFile2.1", 4L);
            rq1.setLogPosition("Queue2", "WALLogFile2.2", 5L);
            rq1.setLogPosition("Queue3", "WALLogFile3.1", 6L);
            rq2.setLogPosition("Queue1", "WALLogFile1.1", 7L);
            rq2.setLogPosition("Queue2", "WALLogFile2.1", 8L);
            rq3.setLogPosition("Queue1", "WALLogFile1.1", 9L);
            Assert.assertEquals((long)1L, (long)rq1.getLogPosition("Queue1", "WALLogFile1.1"));
            Assert.assertEquals((long)2L, (long)rq1.getLogPosition("Queue1", "WALLogFile1.2"));
            Assert.assertEquals((long)4L, (long)rq1.getLogPosition("Queue2", "WALLogFile2.1"));
            Assert.assertEquals((long)6L, (long)rq1.getLogPosition("Queue3", "WALLogFile3.1"));
            Assert.assertEquals((long)7L, (long)rq2.getLogPosition("Queue1", "WALLogFile1.1"));
            Assert.assertEquals((long)8L, (long)rq2.getLogPosition("Queue2", "WALLogFile2.1"));
            Assert.assertEquals((long)9L, (long)rq3.getLogPosition("Queue1", "WALLogFile1.1"));
            Assert.assertEquals((long)rq1.getListOfReplicators().size(), (long)3L);
            Assert.assertEquals((long)rq2.getListOfReplicators().size(), (long)3L);
            Assert.assertEquals((long)rq3.getListOfReplicators().size(), (long)3L);
        }
        catch (ReplicationException e) {
            Assert.fail((String)"testAddLogs threw a ReplicationException");
        }
        try {
            List claimedQueuesFromRq2 = rq1.getUnClaimedQueueIds(server2);
            Assert.assertEquals((long)2L, (long)claimedQueuesFromRq2.size());
            Assert.assertTrue((boolean)claimedQueuesFromRq2.contains("Queue1-" + server2));
            Assert.assertTrue((boolean)claimedQueuesFromRq2.contains("Queue2-" + server2));
            Assert.assertEquals((long)2L, (long)((SortedSet)rq1.claimQueue(server2, "Queue1-" + server2).getSecond()).size());
            Assert.assertEquals((long)1L, (long)((SortedSet)rq1.claimQueue(server2, "Queue2-" + server2).getSecond()).size());
            rq1.removeReplicatorIfQueueIsEmpty(server2);
            Assert.assertEquals((long)rq1.getListOfReplicators().size(), (long)2L);
            Assert.assertEquals((long)rq2.getListOfReplicators().size(), (long)2L);
            Assert.assertEquals((long)rq3.getListOfReplicators().size(), (long)2L);
            Assert.assertEquals((long)5L, (long)rq1.getAllQueues().size());
            Assert.assertEquals((long)2L, (long)rq1.getLogsInQueue("Queue1-" + server2).size());
            Assert.assertEquals((long)1L, (long)rq1.getLogsInQueue("Queue2-" + server2).size());
            Assert.assertEquals((long)7L, (long)rq1.getLogPosition("Queue1-" + server2, "WALLogFile1.1"));
            Assert.assertEquals((long)8L, (long)rq1.getLogPosition("Queue2-" + server2, "WALLogFile2.1"));
            Assert.assertEquals((long)0L, (long)rq2.getAllQueues().size());
            TestCase.assertNull((Object)rq2.getLogsInQueue("Queue1"));
            TestCase.assertNull((Object)rq2.getLogsInQueue("Queue2"));
            rq1.addLog("UnclaimableQueue", "WALLogFile1.1");
            rq1.addLog("UnclaimableQueue", "WALLogFile1.2");
            Assert.assertEquals((long)6L, (long)rq1.getAllQueues().size());
            List claimedQueuesFromRq1 = rq3.getUnClaimedQueueIds(server1);
            for (String queue : claimedQueuesFromRq1) {
                rq3.claimQueue(server1, queue);
            }
            rq3.removeReplicatorIfQueueIsEmpty(server1);
            Assert.assertEquals((long)rq1.getListOfReplicators().size(), (long)1L);
            Assert.assertEquals((long)rq2.getListOfReplicators().size(), (long)1L);
            Assert.assertEquals((long)rq3.getListOfReplicators().size(), (long)1L);
            Assert.assertEquals((long)6L, (long)rq3.getAllQueues().size());
            List noQueues = rq3.getUnClaimedQueueIds("NotARealServer");
            TestCase.assertNull((Object)noQueues);
            Assert.assertEquals((long)6L, (long)rq3.getAllQueues().size());
            noQueues = rq3.getUnClaimedQueueIds(server3);
            Assert.assertNull((Object)noQueues);
            Assert.assertEquals((long)6L, (long)rq3.getAllQueues().size());
            Assert.assertEquals((long)1L, (long)rq3.getListOfReplicators().size());
        }
        catch (ReplicationException e) {
            Assert.fail((String)"testClaimQueue threw a ReplicationException");
        }
    }

    @Test
    public void TestReplicationQueuesClient() throws Exception {
        rq1.addLog("Queue1", "WALLogFile1.1");
        Assert.assertEquals((long)1L, (long)rqc.getLogsInQueue(server1, "Queue1").size());
        rq1.removeLog("Queue1", "WALLogFile1.1");
        Assert.assertEquals((long)0L, (long)rqc.getLogsInQueue(server1, "Queue1").size());
        rq2.addLog("Queue2", "WALLogFile2.1");
        rq2.addLog("Queue2", "WALLogFile2.2");
        Assert.assertEquals((long)2L, (long)rqc.getLogsInQueue(server2, "Queue2").size());
        rq3.addLog("Queue1", "WALLogFile1.1");
        rq3.addLog("Queue3", "WALLogFile3.1");
        rq3.addLog("Queue3", "WALLogFile3.2");
        Assert.assertEquals((long)0L, (long)ds0.getAbortCount());
        TestCase.assertNull((Object)rqc.getLogsInQueue("NotHereServer", "NotHereQueue"));
        TestCase.assertNull((Object)rqc.getLogsInQueue(server1, "NotHereQueue"));
        TestCase.assertNull((Object)rqc.getLogsInQueue("NotHereServer", "WALLogFile1.1"));
        Assert.assertEquals((long)3L, (long)ds0.getAbortCount());
        List replicators = rqc.getListOfReplicators();
        Assert.assertEquals((long)3L, (long)replicators.size());
        Assert.assertTrue((boolean)replicators.contains(server1));
        Assert.assertTrue((boolean)replicators.contains(server2));
        rq1.removeQueue("Queue1");
        Assert.assertEquals((long)2L, (long)rqc.getListOfReplicators().size());
        Assert.assertEquals((long)0L, (long)rqc.getAllQueues(server1).size());
        rq1.addLog("Queue2", "WALLogFile2.1");
        rq1.addLog("Queue3", "WALLogFile3.1");
        Assert.assertEquals((long)2L, (long)rqc.getAllQueues(server1).size());
        rq1.removeAllQueues();
        Assert.assertEquals((long)0L, (long)rqc.getAllQueues(server1).size());
        Assert.assertEquals((long)0L, (long)rqc.getAllQueues("NotHereServer").size());
        Assert.assertEquals((long)5L, (long)rqc.getAllWALs().size());
        rq3.removeLog("Queue1", "WALLogFile1.1");
        Assert.assertEquals((long)4L, (long)rqc.getAllWALs().size());
        rq3.removeAllQueues();
        Assert.assertEquals((long)2L, (long)rqc.getAllWALs().size());
        rq2.removeAllQueues();
        Assert.assertEquals((long)0L, (long)rqc.getAllWALs().size());
    }

    @After
    public void clearQueues() throws Exception {
        rq1.removeAllQueues();
        rq2.removeAllQueues();
        rq3.removeAllQueues();
        Assert.assertEquals((long)0L, (long)rq1.getAllQueues().size());
        Assert.assertEquals((long)0L, (long)rq2.getAllQueues().size());
        Assert.assertEquals((long)0L, (long)rq3.getAllQueues().size());
        ds0.resetAbortCount();
        ds1.resetAbortCount();
        ds2.resetAbortCount();
        ds3.resetAbortCount();
    }

    @After
    public void tearDown() throws KeeperException, IOException {
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)replicationZNode);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility.shutdownMiniCluster();
        utility.shutdownMiniZKCluster();
    }

    static {
        server0 = ServerName.valueOf((String)"hostname0.example.org", (int)1234, (long)-1L).toString();
        server1 = ServerName.valueOf((String)"hostname1.example.org", (int)1234, (long)1L).toString();
        server2 = ServerName.valueOf((String)"hostname2.example.org", (int)1234, (long)1L).toString();
        server3 = ServerName.valueOf((String)"hostname3.example.org", (int)1234, (long)1L).toString();
    }

    static class DummyServer
    implements Server {
        private String serverName;
        private boolean isAborted = false;
        private boolean isStopped = false;
        private int abortCount = 0;

        public DummyServer(String serverName) {
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            ++this.abortCount;
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isStopped = true;
        }

        public boolean isStopped() {
            return this.isStopped;
        }

        public ChoreService getChoreService() {
            return null;
        }

        public ClusterConnection getClusterConnection() {
            return null;
        }

        public int getAbortCount() {
            return this.abortCount;
        }

        public void resetAbortCount() {
            this.abortCount = 0;
        }

        public FileSystem getFileSystem() {
            return null;
        }

        public boolean isStopping() {
            return false;
        }
    }
}

