/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueues;
import org.apache.hadoop.hbase.replication.ReplicationQueuesArguments;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClientArguments;
import org.apache.hadoop.hbase.replication.ReplicationTableBase;
import org.apache.hadoop.hbase.replication.TableBasedReplicationQueuesClientImpl;
import org.apache.hadoop.hbase.replication.TableBasedReplicationQueuesImpl;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, MediumTests.class})
public class TestReplicationTableBase {
    private static long SLEEP_MILLIS = 5000L;
    private static long TIME_OUT_MILLIS = 3000L;
    private static Configuration conf;
    private static HBaseTestingUtility utility;
    private static ZooKeeperWatcher zkw;
    private static ReplicationTableBase rb;
    private static ReplicationQueues rq;
    private static ReplicationQueuesClient rqc;
    private volatile boolean asyncRequestSuccess = false;

    @Test
    public void testSlowStartup() throws Exception {
        utility = new HBaseTestingUtility();
        utility.startMiniZKCluster();
        conf = utility.getConfiguration();
        conf.setClass("hbase.region.replica.replication.replicationQueues.class", TableBasedReplicationQueuesImpl.class, ReplicationQueues.class);
        conf.setClass("hbase.region.replica.replication.replicationQueuesClient.class", TableBasedReplicationQueuesClientImpl.class, ReplicationQueuesClient.class);
        zkw = HBaseTestingUtility.getZooKeeperWatcher(utility);
        utility.waitFor(0L, TIME_OUT_MILLIS, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                rb = new ReplicationTableBase(conf, (Abortable)zkw){};
                rq = ReplicationFactory.getReplicationQueues((ReplicationQueuesArguments)new ReplicationQueuesArguments(conf, (Abortable)zkw, zkw));
                rqc = ReplicationFactory.getReplicationQueuesClient((ReplicationQueuesClientArguments)new ReplicationQueuesClientArguments(conf, (Abortable)zkw, zkw));
                return true;
            }

            public String explainFailure() throws Exception {
                return "Failed to initialize ReplicationTableBase, TableBasedReplicationQueuesClient and TableBasedReplicationQueues after a timeout=" + TIME_OUT_MILLIS + " ms. Their initialization should be non-blocking";
            }
        });
        final RequestReplicationQueueData async = new RequestReplicationQueueData();
        async.start();
        Thread.sleep(SLEEP_MILLIS);
        Assert.assertFalse((boolean)rb.getInitializationStatus());
        Assert.assertFalse((boolean)this.asyncRequestSuccess);
        utility.startMiniCluster();
        utility.waitFor(0L, TIME_OUT_MILLIS, new Waiter.ExplainingPredicate<Exception>(){

            public boolean evaluate() throws Exception {
                async.join();
                return true;
            }

            public String explainFailure() throws Exception {
                return "ReplicationQueue failed to return list of replicators even after Replication Table was initialized timeout=" + TIME_OUT_MILLIS + " ms";
            }
        });
        Assert.assertTrue((boolean)this.asyncRequestSuccess);
    }

    public class RequestReplicationQueueData
    extends Thread {
        @Override
        public void run() {
            Assert.assertEquals((long)0L, (long)rq.getListOfReplicators().size());
            TestReplicationTableBase.this.asyncRequestSuccess = true;
        }
    }
}

