/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.replication.ReplicationAdmin;
import org.apache.hadoop.hbase.codec.KeyValueCodecWithTags;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ReplicationTests.class, LargeTests.class})
public class TestReplicationWithTags {
    private static final Log LOG = LogFactory.getLog(TestReplicationWithTags.class);
    private static final byte TAG_TYPE = 1;
    private static Configuration conf1 = HBaseConfiguration.create();
    private static Configuration conf2;
    private static ReplicationAdmin replicationAdmin;
    private static Connection connection1;
    private static Connection connection2;
    private static Table htable1;
    private static Table htable2;
    private static HBaseTestingUtility utility1;
    private static HBaseTestingUtility utility2;
    private static final long SLEEP_TIME = 500L;
    private static final int NB_RETRIES = 10;
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] ROW;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Throwable throwable;
        Admin admin;
        conf1.setInt("hfile.format.version", 3);
        conf1.set("zookeeper.znode.parent", "/1");
        conf1.setInt("replication.source.size.capacity", 10240);
        conf1.setLong("replication.source.sleepforretries", 100L);
        conf1.setInt("hbase.regionserver.maxlogs", 10);
        conf1.setLong("hbase.master.logcleaner.ttl", 10L);
        conf1.setInt("zookeeper.recovery.retry", 1);
        conf1.setInt("zookeeper.recovery.retry.intervalmill", 10);
        conf1.setLong("hbase.server.thread.wakefrequency", 100L);
        conf1.setInt("replication.stats.thread.period.seconds", 5);
        conf1.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf1.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf1.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForTagsAtSource.class.getName()});
        utility1 = new HBaseTestingUtility(conf1);
        utility1.startMiniZKCluster();
        MiniZooKeeperCluster miniZK = utility1.getZkCluster();
        conf1 = utility1.getConfiguration();
        replicationAdmin = new ReplicationAdmin(conf1);
        LOG.info((Object)"Setup first Zk");
        conf2 = HBaseConfiguration.create((Configuration)conf1);
        conf2.setInt("hfile.format.version", 3);
        conf2.set("zookeeper.znode.parent", "/2");
        conf2.setInt("hbase.client.retries.number", 6);
        conf2.setBoolean("hbase.tests.use.shortcircuit.reads", false);
        conf2.setStrings("hbase.replication.rpc.codec", new String[]{KeyValueCodecWithTags.class.getName()});
        conf2.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForTagsAtSink.class.getName()});
        utility2 = new HBaseTestingUtility(conf2);
        utility2.setZkCluster(miniZK);
        LOG.info((Object)"Setup second Zk");
        utility1.startMiniCluster(2);
        utility2.startMiniCluster(2);
        ReplicationPeerConfig rpc = new ReplicationPeerConfig();
        rpc.setClusterKey(utility2.getClusterKey());
        replicationAdmin.addPeer("2", rpc, null);
        HTableDescriptor table = new HTableDescriptor(TABLE_NAME);
        HColumnDescriptor fam = new HColumnDescriptor(FAMILY);
        fam.setMaxVersions(3);
        fam.setScope(1);
        table.addFamily(fam);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)conf1);){
            admin = conn.getAdmin();
            throwable = null;
            try {
                admin.createTable((TableDescriptor)table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        conn = ConnectionFactory.createConnection((Configuration)conf2);
        var5_5 = null;
        try {
            admin = conn.getAdmin();
            throwable = null;
            try {
                admin.createTable((TableDescriptor)table, HBaseTestingUtility.KEYS_FOR_HBA_CREATE_TABLE);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (admin != null) {
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var5_5 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var5_5.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        htable1 = utility1.getConnection().getTable(TABLE_NAME);
        htable2 = utility2.getConnection().getTable(TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        utility2.shutdownMiniCluster();
        utility1.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testReplicationWithCellTags() throws Exception {
        LOG.info((Object)"testSimplePutDelete");
        Put put = new Put(ROW);
        put.setAttribute("visibility", Bytes.toBytes((String)"myTag3"));
        put.addColumn(FAMILY, ROW, ROW);
        htable1 = utility1.getConnection().getTable(TABLE_NAME);
        htable1.put(put);
        Get get = new Get(ROW);
        try {
            for (int i = 0; i < 10; ++i) {
                Result res;
                if (i == 9) {
                    Assert.fail((String)"Waited too much time for put replication");
                }
                if (!(res = htable2.get(get)).isEmpty()) {
                    Assert.assertArrayEquals((byte[])res.value(), (byte[])ROW);
                    Assert.assertEquals((long)1L, (long)TestCoprocessorForTagsAtSink.tags.size());
                    Tag tag = TestCoprocessorForTagsAtSink.tags.get(0);
                    Assert.assertEquals((long)1L, (long)tag.getType());
                    break;
                }
                LOG.info((Object)"Row not available");
                Thread.sleep(500L);
            }
        }
        finally {
            TestCoprocessorForTagsAtSink.tags = null;
        }
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"TestReplicationWithTags");
        FAMILY = Bytes.toBytes((String)"f");
        ROW = Bytes.toBytes((String)"row");
    }

    public static class TestCoprocessorForTagsAtSink
    implements RegionCoprocessor,
    RegionObserver {
        public static List<Tag> tags = null;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            if (results.size() > 0 && !results.isEmpty()) {
                Cell cell = results.get(0);
                tags = TagUtil.asList((byte[])cell.getTagsArray(), (int)cell.getTagsOffset(), (int)cell.getTagsLength());
            }
        }
    }

    public static class TestCoprocessorForTagsAtSource
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            byte[] attribute = put.getAttribute("visibility");
            byte[] cf = null;
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            if (attribute != null) {
                for (List edits : put.getFamilyCellMap().values()) {
                    for (Cell cell : edits) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (cf == null) {
                            cf = CellUtil.cloneFamily((Cell)kv);
                        }
                        ArrayBackedTag tag = new ArrayBackedTag(1, attribute);
                        ArrayList<ArrayBackedTag> tagList = new ArrayList<ArrayBackedTag>(1);
                        tagList.add(tag);
                        KeyValue newKV = new KeyValue(CellUtil.cloneRow((Cell)kv), 0, (int)kv.getRowLength(), CellUtil.cloneFamily((Cell)kv), 0, (int)kv.getFamilyLength(), CellUtil.cloneQualifier((Cell)kv), 0, kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getTypeByte()), CellUtil.cloneValue((Cell)kv), 0, kv.getValueLength(), tagList);
                        updatedCells.add(newKV);
                    }
                }
                put.getFamilyCellMap().remove(cf);
                put.getFamilyCellMap().put(cf, updatedCells);
            }
        }
    }
}

