/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, SmallTests.class})
public class TestUsersOperationsWithSecureHadoop {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final File KEYTAB_FILE = new File(TEST_UTIL.getDataTestDir("keytab").toUri().getPath());
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;

    @BeforeClass
    public static void setUp() throws Exception {
        KDC = TEST_UTIL.setupMiniKdc(KEYTAB_FILE);
        PRINCIPAL = "hbase/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL});
        HBaseKerberosUtils.setPrincipalForTesting(PRINCIPAL + "@" + KDC.getRealm());
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (KDC != null) {
            KDC.stop();
        }
        TEST_UTIL.cleanupTestDir();
    }

    @Test
    public void testUserLoginInSecureHadoop() throws Exception {
        UserGroupInformation defaultLogin = UserGroupInformation.getLoginUser();
        Configuration conf = HBaseKerberosUtils.getConfigurationWoPrincipal();
        User.login((Configuration)conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)"localhost");
        UserGroupInformation failLogin = UserGroupInformation.getLoginUser();
        Assert.assertTrue((String)"ugi should be the same in case fail login", (boolean)defaultLogin.equals((Object)failLogin));
        String nnKeyTab = HBaseKerberosUtils.getKeytabFileForTesting();
        String dnPrincipal = HBaseKerberosUtils.getPrincipalForTesting();
        Assert.assertNotNull((String)"KerberosKeytab was not specified", (Object)nnKeyTab);
        Assert.assertNotNull((String)"KerberosPrincipal was not specified", (Object)dnPrincipal);
        conf = HBaseKerberosUtils.getSecuredConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        User.login((Configuration)conf, (String)"hbase.regionserver.keytab.file", (String)"hbase.regionserver.kerberos.principal", (String)"localhost");
        UserGroupInformation successLogin = UserGroupInformation.getLoginUser();
        Assert.assertFalse((String)"ugi should be different in in case success login", (boolean)defaultLogin.equals((Object)successLogin));
    }

    static {
        HOST = "localhost";
    }
}

