/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CategoryBasedTimeout;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.security.access.CoprocessorWhitelistMasterObserver;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestCoprocessorWhitelistMasterObserver
extends SecureTestUtil {
    private static final Log LOG = LogFactory.getLog(TestCoprocessorWhitelistMasterObserver.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final TableName TEST_TABLE = TableName.valueOf((String)"testTable");
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"fam1");
    @ClassRule
    public static TestRule timeout = CategoryBasedTimeout.forClass(TestCoprocessorWhitelistMasterObserver.class);

    @After
    public void tearDownTestCoprocessorWhitelistMasterObserver() throws Exception {
        Admin admin = UTIL.getAdmin();
        try {
            try {
                admin.disableTable(TEST_TABLE);
            }
            catch (TableNotEnabledException ex) {
                LOG.info((Object)"Table was left disabled by test");
            }
            admin.deleteTable(TEST_TABLE);
        }
        catch (TableNotFoundException ex) {
            LOG.info((Object)"Table was not created for some reason");
        }
        UTIL.shutdownMiniCluster();
    }

    private static void positiveTestCase(String[] whitelistedPaths, String coprocessorPath) throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CoprocessorWhitelistMasterObserver.class.getName());
        conf.setStrings("hbase.coprocessor.region.whitelist.paths", whitelistedPaths);
        conf.setInt("hbase.client.retries.number", 1);
        UTIL.startMiniCluster();
        UTIL.createTable(TEST_TABLE, (byte[][])new byte[][]{TEST_FAMILY});
        UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Table t = connection.getTable(TEST_TABLE);
        HTableDescriptor htd = new HTableDescriptor(t.getTableDescriptor());
        htd.addCoprocessor("net.clayb.hbase.coprocessor.NotWhitelisted", new Path(coprocessorPath), 0x3FFFFFFF, null);
        LOG.info((Object)"Modifying Table");
        try {
            connection.getAdmin().modifyTable(TEST_TABLE, (TableDescriptor)htd);
            Assert.fail((String)"Expected coprocessor to raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.info((Object)"Done Modifying Table");
        Assert.assertEquals((long)0L, (long)t.getTableDescriptor().getCoprocessors().size());
    }

    private static void negativeTestCase(String[] whitelistedPaths, String coprocessorPath) throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.setInt("hbase.client.retries.number", 1);
        conf.set("hbase.coprocessor.master.classes", CoprocessorWhitelistMasterObserver.class.getName());
        conf.setStrings("hbase.coprocessor.region.whitelist.paths", whitelistedPaths);
        UTIL.startMiniCluster();
        UTIL.createTable(TEST_TABLE, (byte[][])new byte[][]{TEST_FAMILY});
        UTIL.waitUntilAllRegionsAssigned(TEST_TABLE);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        admin.disableTable(TEST_TABLE);
        Table t = connection.getTable(TEST_TABLE);
        HTableDescriptor htd = new HTableDescriptor(t.getTableDescriptor());
        htd.addCoprocessor("net.clayb.hbase.coprocessor.Whitelisted", new Path(coprocessorPath), 0x3FFFFFFF, null);
        LOG.info((Object)"Modifying Table");
        admin.modifyTable(TEST_TABLE, (TableDescriptor)htd);
        Assert.assertEquals((long)1L, (long)t.getTableDescriptor().getCoprocessors().size());
        LOG.info((Object)"Done Modifying Table");
    }

    @Test
    public void testSubstringNonWhitelisted() throws Exception {
        TestCoprocessorWhitelistMasterObserver.positiveTestCase(new String[]{"/permitted/*"}, "file:///notpermitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testDifferentFileSystemNonWhitelisted() throws Exception {
        TestCoprocessorWhitelistMasterObserver.positiveTestCase(new String[]{"hdfs://foo/bar"}, "file:///notpermitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testSchemeAndDirectorywhitelisted() throws Exception {
        TestCoprocessorWhitelistMasterObserver.negativeTestCase(new String[]{"/tmp", "file:///permitted/*"}, "file:///permitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testSchemeWhitelisted() throws Exception {
        TestCoprocessorWhitelistMasterObserver.negativeTestCase(new String[]{"file:///"}, "file:///permitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testDFSNameWhitelistedWorks() throws Exception {
        TestCoprocessorWhitelistMasterObserver.negativeTestCase(new String[]{"hdfs://Your-FileSystem"}, "hdfs://Your-FileSystem/permitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testDFSNameNotWhitelistedFails() throws Exception {
        TestCoprocessorWhitelistMasterObserver.positiveTestCase(new String[]{"hdfs://Your-FileSystem"}, "hdfs://My-FileSystem/permitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testBlanketWhitelist() throws Exception {
        TestCoprocessorWhitelistMasterObserver.negativeTestCase(new String[]{"*"}, "hdfs:///permitted/couldnotpossiblyexist.jar");
    }

    @Test
    public void testCreationNonWhitelistedCoprocessorPath() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CoprocessorWhitelistMasterObserver.class.getName());
        conf.setStrings("hbase.coprocessor.region.whitelist.paths", new String[0]);
        conf.setInt("hbase.client.retries.number", 1);
        UTIL.startMiniCluster();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        htd.addFamily(hcd);
        htd.addCoprocessor("net.clayb.hbase.coprocessor.NotWhitelisted", new Path("file:///notpermitted/couldnotpossiblyexist.jar"), 0x3FFFFFFF, null);
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        LOG.info((Object)"Creating Table");
        try {
            admin.createTable((TableDescriptor)htd);
            Assert.fail((String)"Expected coprocessor to raise IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.info((Object)"Done Creating Table");
        Assert.assertEquals((Object[])new HTableDescriptor[0], (Object[])admin.listTables("^" + TEST_TABLE.getNameAsString() + "$"));
    }

    @Test
    public void testCreationClasspathCoprocessor() throws Exception {
        Configuration conf = UTIL.getConfiguration();
        conf.set("hbase.coprocessor.master.classes", CoprocessorWhitelistMasterObserver.class.getName());
        conf.setStrings("hbase.coprocessor.region.whitelist.paths", new String[0]);
        conf.setInt("hbase.client.retries.number", 1);
        UTIL.startMiniCluster();
        HTableDescriptor htd = new HTableDescriptor(TEST_TABLE);
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY);
        htd.addFamily(hcd);
        htd.addCoprocessor(TestRegionObserver.class.getName());
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        LOG.info((Object)"Creating Table");
        admin.createTable((TableDescriptor)htd);
        LOG.info((Object)"Done Creating Table");
        Table t = connection.getTable(TEST_TABLE);
        Assert.assertEquals((long)1L, (long)t.getTableDescriptor().getCoprocessors().size());
    }

    public static class TestRegionObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }
    }
}

