/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.security.token.AuthenticationKey;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestZKSecretWatcher {
    private static final Log LOG = LogFactory.getLog(TestZKSecretWatcher.class);
    private static HBaseTestingUtility TEST_UTIL;
    private static AuthenticationTokenSecretManager KEY_MASTER;
    private static AuthenticationTokenSecretManagerForTest KEY_SLAVE;
    private static AuthenticationTokenSecretManager KEY_SLAVE2;
    private static AuthenticationTokenSecretManager KEY_SLAVE3;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        Configuration conf = TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zk = TestZKSecretWatcher.newZK(conf, "server1", new MockAbortable());
        AuthenticationTokenSecretManagerForTest[] tmp = new AuthenticationTokenSecretManagerForTest[2];
        tmp[0] = new AuthenticationTokenSecretManagerForTest(conf, zk, "server1", 3600000L, 60000L);
        tmp[0].start();
        zk = TestZKSecretWatcher.newZK(conf, "server2", new MockAbortable());
        tmp[1] = new AuthenticationTokenSecretManagerForTest(conf, zk, "server2", 3600000L, 60000L);
        tmp[1].start();
        while (KEY_MASTER == null) {
            for (int i = 0; i < 2; ++i) {
                if (!tmp[i].isMaster()) continue;
                KEY_MASTER = tmp[i];
                KEY_SLAVE = tmp[(i + 1) % 2];
                break;
            }
            Thread.sleep(500L);
        }
        LOG.info((Object)("Master is " + KEY_MASTER.getName() + ", slave is " + KEY_SLAVE.getName()));
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testKeyUpdate() throws Exception {
        Assert.assertTrue((boolean)KEY_MASTER.isMaster());
        Assert.assertFalse((boolean)KEY_SLAVE.isMaster());
        boolean maxKeyId = false;
        KEY_MASTER.rollCurrentKey();
        AuthenticationKey key1 = KEY_MASTER.getCurrentKey();
        Assert.assertNotNull((Object)key1);
        LOG.debug((Object)("Master current key: " + key1.getKeyId()));
        Thread.sleep(1000L);
        AuthenticationKey slaveCurrent = KEY_SLAVE.getCurrentKey();
        Assert.assertNotNull((Object)slaveCurrent);
        Assert.assertEquals((Object)key1, (Object)slaveCurrent);
        LOG.debug((Object)("Slave current key: " + slaveCurrent.getKeyId()));
        KEY_MASTER.rollCurrentKey();
        AuthenticationKey key2 = KEY_MASTER.getCurrentKey();
        LOG.debug((Object)("Master new current key: " + key2.getKeyId()));
        KEY_MASTER.rollCurrentKey();
        AuthenticationKey key3 = KEY_MASTER.getCurrentKey();
        LOG.debug((Object)("Master new current key: " + key3.getKeyId()));
        key1.setExpiration(EnvironmentEdgeManager.currentTime() - 1000L);
        KEY_MASTER.removeExpiredKeys();
        Assert.assertNull((Object)KEY_MASTER.getKey(key1.getKeyId()));
        KEY_SLAVE.getLatch().await();
        AuthenticationKey slave2 = KEY_SLAVE.getKey(key2.getKeyId());
        Assert.assertNotNull((Object)slave2);
        Assert.assertEquals((Object)key2, (Object)slave2);
        AuthenticationKey slave3 = KEY_SLAVE.getKey(key3.getKeyId());
        Assert.assertNotNull((Object)slave3);
        Assert.assertEquals((Object)key3, (Object)slave3);
        slaveCurrent = KEY_SLAVE.getCurrentKey();
        Assert.assertEquals((Object)key3, (Object)slaveCurrent);
        LOG.debug((Object)("Slave current key: " + slaveCurrent.getKeyId()));
        Assert.assertNull((Object)KEY_SLAVE.getKey(key1.getKeyId()));
        Configuration conf = TEST_UTIL.getConfiguration();
        ZooKeeperWatcher zk = TestZKSecretWatcher.newZK(conf, "server3", new MockAbortable());
        KEY_SLAVE2 = new AuthenticationTokenSecretManager(conf, zk, "server3", 3600000L, 60000L);
        KEY_SLAVE2.start();
        Thread.sleep(1000L);
        slave2 = KEY_SLAVE2.getKey(key2.getKeyId());
        Assert.assertNotNull((Object)slave2);
        Assert.assertEquals((Object)key2, (Object)slave2);
        slave3 = KEY_SLAVE2.getKey(key3.getKeyId());
        Assert.assertNotNull((Object)slave3);
        Assert.assertEquals((Object)key3, (Object)slave3);
        slaveCurrent = KEY_SLAVE2.getCurrentKey();
        Assert.assertEquals((Object)key3, (Object)slaveCurrent);
        Assert.assertNull((Object)KEY_SLAVE2.getKey(key1.getKeyId()));
        KEY_MASTER.stop();
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)KEY_MASTER.isMaster());
        AuthenticationTokenSecretManager mgrs = new AuthenticationTokenSecretManager[]{KEY_SLAVE, KEY_SLAVE2};
        AuthenticationTokenSecretManager newMaster = null;
        int tries = 0;
        while (newMaster == null && tries++ < 5) {
            for (AuthenticationTokenSecretManager mgr : mgrs) {
                if (!mgr.isMaster()) continue;
                newMaster = mgr;
                break;
            }
            if (newMaster != null) continue;
            Thread.sleep(500L);
        }
        Assert.assertNotNull(newMaster);
        AuthenticationKey current = newMaster.getCurrentKey();
        Assert.assertTrue((current.getKeyId() >= slaveCurrent.getKeyId() ? 1 : 0) != 0);
        LOG.debug((Object)("New master, current key: " + current.getKeyId()));
        newMaster.rollCurrentKey();
        AuthenticationKey newCurrent = newMaster.getCurrentKey();
        LOG.debug((Object)("New master, rolled new current key: " + newCurrent.getKeyId()));
        Assert.assertTrue((newCurrent.getKeyId() > current.getKeyId() ? 1 : 0) != 0);
        ZooKeeperWatcher zk3 = TestZKSecretWatcher.newZK(conf, "server4", new MockAbortable());
        KEY_SLAVE3 = new AuthenticationTokenSecretManager(conf, zk3, "server4", 3600000L, 60000L);
        KEY_SLAVE3.start();
        Thread.sleep(5000L);
        newMaster.stop();
        Thread.sleep(5000L);
        Assert.assertFalse((boolean)newMaster.isMaster());
        mgrs = new AuthenticationTokenSecretManager[]{KEY_SLAVE, KEY_SLAVE2, KEY_SLAVE3};
        newMaster = null;
        tries = 0;
        while (newMaster == null && tries++ < 5) {
            for (AuthenticationTokenSecretManager mgr : mgrs) {
                if (!mgr.isMaster()) continue;
                newMaster = mgr;
                break;
            }
            if (newMaster != null) continue;
            Thread.sleep(500L);
        }
        Assert.assertNotNull((Object)newMaster);
        AuthenticationKey current2 = newMaster.getCurrentKey();
        Assert.assertTrue((current2.getKeyId() >= newCurrent.getKeyId() ? 1 : 0) != 0);
        LOG.debug((Object)("New master 2, current key: " + current2.getKeyId()));
        newMaster.rollCurrentKey();
        AuthenticationKey newCurrent2 = newMaster.getCurrentKey();
        LOG.debug((Object)("New master 2, rolled new current key: " + newCurrent2.getKeyId()));
        Assert.assertTrue((newCurrent2.getKeyId() > current2.getKeyId() ? 1 : 0) != 0);
    }

    private static ZooKeeperWatcher newZK(Configuration conf, String name, Abortable abort) throws Exception {
        Configuration copy = HBaseConfiguration.create((Configuration)conf);
        ZooKeeperWatcher zk = new ZooKeeperWatcher(copy, name, abort);
        return zk;
    }

    private static class AuthenticationTokenSecretManagerForTest
    extends AuthenticationTokenSecretManager {
        private CountDownLatch latch = new CountDownLatch(1);

        public AuthenticationTokenSecretManagerForTest(Configuration conf, ZooKeeperWatcher zk, String serverName, long keyUpdateInterval, long tokenMaxLifetime) {
            super(conf, zk, serverName, keyUpdateInterval, tokenMaxLifetime);
        }

        synchronized boolean removeKey(Integer keyId) {
            boolean b = super.removeKey(keyId);
            if (b) {
                this.latch.countDown();
            }
            return b;
        }

        CountDownLatch getLatch() {
            return this.latch;
        }
    }

    private static class MockAbortable
    implements Abortable {
        private boolean abort;

        private MockAbortable() {
        }

        public void abort(String reason, Throwable e) {
            LOG.info((Object)("Aborting: " + reason), e);
            this.abort = true;
        }

        public boolean isAborted() {
            return this.abort;
        }
    }
}

