/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={SecurityTests.class, LargeTests.class})
public class TestWithDisabledAuthorization {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static final String PRIVATE = "private";
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q");
    private static final byte[] ZERO = Bytes.toBytes((long)0L);
    @Rule
    public final TestName TEST_NAME = new TestName();
    private static User SUPERUSER;
    private static User USER_RW;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.metahandler.count", 10);
        SecureTestUtil.configureSuperuser(conf);
        VisibilityTestUtil.enableVisiblityLabels(conf);
        conf.setBoolean("hbase.security.authorization", false);
        TEST_UTIL.startMiniCluster();
        TEST_UTIL.waitUntilAllRegionsAssigned(VisibilityConstants.LABELS_TABLE_NAME);
        SUPERUSER = User.createUserForTesting((Configuration)conf, (String)"admin", (String[])new String[]{"supergroup"});
        USER_RW = User.createUserForTesting((Configuration)conf, (String)"rwuser", (String[])new String[0]);
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.addLabels((Connection)conn, (String[])new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL, TestWithDisabledAuthorization.PRIVATE});
                    VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL}, (String)USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testManageUserAuths() throws Throwable {
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.setAuths((Connection)conn, (String[])new String[]{TestWithDisabledAuthorization.SECRET, TestWithDisabledAuthorization.CONFIDENTIAL}, (String)USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        PrivilegedExceptionAction<List<String>> getAuths = new PrivilegedExceptionAction<List<String>>(){

            @Override
            public List<String> run() throws Exception {
                VisibilityLabelsProtos.GetAuthsResponse authsResponse = null;
                try {
                    Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                    Object object = null;
                    try {
                        authsResponse = VisibilityClient.getAuths((Connection)conn, (String)USER_RW.getShortName());
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (conn != null) {
                            if (object != null) {
                                try {
                                    conn.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                conn.close();
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                ArrayList<String> authsList = new ArrayList<String>(authsResponse.getAuthList().size());
                for (ByteString authBS : authsResponse.getAuthList()) {
                    authsList.add(Bytes.toString((byte[])authBS.toByteArray()));
                }
                return authsList;
            }
        };
        List authsList = (List)SUPERUSER.runAs((PrivilegedExceptionAction)getAuths);
        Assert.assertEquals((long)2L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(SECRET));
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.clearAuths((Connection)conn, (String[])new String[]{TestWithDisabledAuthorization.SECRET}, (String)USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        authsList = (List)SUPERUSER.runAs((PrivilegedExceptionAction)getAuths);
        Assert.assertEquals((long)1L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        SUPERUSER.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);){
                    VisibilityClient.clearAuths((Connection)conn, (String[])new String[]{TestWithDisabledAuthorization.CONFIDENTIAL}, (String)USER_RW.getShortName());
                }
                catch (Throwable t) {
                    Assert.fail((String)"Should not have failed");
                }
                return null;
            }
        });
        authsList = (List)SUPERUSER.runAs((PrivilegedExceptionAction)getAuths);
        Assert.assertEquals((long)0L, (long)authsList.size());
    }

    @Test(timeout=180000L)
    public void testPassiveVisibility() throws Exception {
        try (Table t = TestWithDisabledAuthorization.createTableAndWriteDataWithLabels(TableName.valueOf((String)this.TEST_NAME.getMethodName()), SECRET, PRIVATE, "secret|confidential", "private|confidential");){
            Result[] next;
            Scan s = new Scan();
            s.setAuthorizations(new Authorizations(new String[0]));
            try (ResultScanner scanner = t.getScanner(s);){
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET}));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable next2) {
                var5_7 = next2;
                throw next2;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable next2) {
                            var5_7.addSuppressed(next2);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL}));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable next3) {
                var5_7 = next3;
                throw next3;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable next3) {
                            var5_7.addSuppressed(next3);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
            s = new Scan();
            s.setAuthorizations(new Authorizations(new String[]{SECRET, CONFIDENTIAL, PRIVATE}));
            scanner = t.getScanner(s);
            var5_7 = null;
            try {
                next = scanner.next(10);
                Assert.assertEquals((long)next.length, (long)4L);
            }
            catch (Throwable throwable) {
                var5_7 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var5_7 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    static Table createTableAndWriteDataWithLabels(TableName tableName, String ... labelExps) throws Exception {
        ArrayList<Put> puts = new ArrayList<Put>(labelExps.length + 1);
        for (int i = 0; i < labelExps.length; ++i) {
            Put put = new Put(Bytes.toBytes((String)("row" + (i + 1))));
            put.addColumn(TEST_FAMILY, TEST_QUALIFIER, Long.MAX_VALUE, ZERO);
            put.setCellVisibility(new CellVisibility(labelExps[i]));
            puts.add(put);
        }
        Table table = TEST_UTIL.createTable(tableName, TEST_FAMILY);
        table.put(puts);
        return table;
    }
}

