/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.regionserver.ConstantSizeRegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.snapshot.FlushSnapshotSubprocedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotManifestV2;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class, RegionServerTests.class})
public class TestRegionSnapshotTask {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration conf;
    private static FileSystem fs;
    private static Path rootDir;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.hfile.compaction.discharger.interval", 1000);
        conf.setInt("hbase.master.hfilecleaner.ttl", 1000);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.getHBaseCluster().waitForActiveAndReadyMaster();
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        rootDir = FSUtils.getRootDir((Configuration)conf);
        fs = TEST_UTIL.getTestFileSystem();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=30000L)
    public void testAddRegionWithCompactions() throws Exception {
        TableName tableName = TableName.valueOf((String)"test_table");
        Table table = this.setupTable(tableName);
        List<HRegion> hRegions = TEST_UTIL.getHBaseCluster().getRegions(tableName);
        SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setTable(tableName.getNameAsString()).setType(SnapshotProtos.SnapshotDescription.Type.FLUSH).setName("test_table_snapshot").setVersion(2).build();
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(snapshot.getName());
        HRegion region = (HRegion)Mockito.spy((Object)hRegions.get(0));
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)snapshot, (Path)rootDir);
        SnapshotManifest manifest = SnapshotManifest.create((Configuration)conf, (FileSystem)fs, (Path)workingDir, (SnapshotProtos.SnapshotDescription)snapshot, (ForeignExceptionSnare)monitor);
        manifest.addTableDescriptor((TableDescriptor)table.getTableDescriptor());
        if (!fs.exists(workingDir)) {
            fs.mkdirs(workingDir);
        }
        Assert.assertTrue((boolean)fs.exists(workingDir));
        SnapshotDescriptionUtils.writeSnapshotInfo((SnapshotProtos.SnapshotDescription)snapshot, (Path)workingDir, (FileSystem)fs);
        ((HRegion)Mockito.doAnswer(__ -> {
            this.addRegionToSnapshot(snapshot, region, manifest);
            return null;
        }).when((Object)region)).addRegionToSnapshot(snapshot, (ForeignExceptionSnare)monitor);
        FlushSnapshotSubprocedure.RegionSnapshotTask snapshotTask = new FlushSnapshotSubprocedure.RegionSnapshotTask(region, snapshot, true, monitor);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future f = executor.submit(snapshotTask);
        this.LOG.info((Object)"Starting major compaction");
        region.compact(true);
        this.LOG.info((Object)"Finished major compaction");
        f.get();
        manifest.consolidate();
        Assert.assertNotNull((Object)manifest.getRegionManifests());
        Assert.assertEquals((long)1L, (long)manifest.getRegionManifests().size());
        SnapshotReferenceUtil.verifySnapshot((Configuration)conf, (FileSystem)fs, (SnapshotManifest)manifest);
    }

    private void addRegionToSnapshot(SnapshotProtos.SnapshotDescription snapshot, HRegion region, SnapshotManifest manifest) throws Exception {
        this.LOG.info((Object)("Adding region to snapshot: " + region.getRegionInfo().getRegionNameAsString()));
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)snapshot, (Path)rootDir);
        SnapshotManifest.RegionVisitor visitor = this.createRegionVisitorWithDelay(snapshot, workingDir);
        manifest.addRegion(region, visitor);
        this.LOG.info((Object)("Added the region to snapshot: " + region.getRegionInfo().getRegionNameAsString()));
    }

    private SnapshotManifest.RegionVisitor createRegionVisitorWithDelay(SnapshotProtos.SnapshotDescription desc, Path workingDir) {
        return new SnapshotManifestV2.ManifestBuilder(conf, fs, workingDir){

            public void storeFile(SnapshotProtos.SnapshotRegionManifest.Builder region, SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family, StoreFileInfo storeFile) throws IOException {
                try {
                    TestRegionSnapshotTask.this.LOG.debug((Object)"Introducing delay before adding store file to manifest");
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    TestRegionSnapshotTask.this.LOG.error((Object)("Interrupted due to error: " + ex));
                }
                super.storeFile(region, family, storeFile);
            }
        };
    }

    private Table setupTable(TableName tableName) throws Exception {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        builder.setMemStoreFlushSize(5000L).setRegionSplitPolicyClassName(ConstantSizeRegionSplitPolicy.class.getName()).setMaxFileSize(0x6400000L).setValue("hbase.hstore.compactionThreshold", "250");
        TableDescriptor td = builder.build();
        byte[] fam = Bytes.toBytes((String)"fam");
        Table table = TEST_UTIL.createTable(td, (byte[][])new byte[][]{fam}, TEST_UTIL.getConfiguration());
        TEST_UTIL.loadTable(table, fam);
        return table;
    }
}

