/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HFileCorruptionChecker;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, LargeTests.class})
public class TestHBaseFsckEncryption {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private HTableDescriptor htd;
    private Key cfKey;

    @Before
    public void setUp() throws Exception {
        this.conf = TEST_UTIL.getConfiguration();
        this.conf.setInt("hfile.format.version", 3);
        this.conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        this.conf.set("hbase.crypto.master.key.name", "hbase");
        SecureRandom rng = new SecureRandom();
        byte[] keyBytes = new byte[16];
        rng.nextBytes(keyBytes);
        String algorithm = this.conf.get("hbase.crypto.key.algorithm", "AES");
        this.cfKey = new SecretKeySpec(keyBytes, algorithm);
        TEST_UTIL.startMiniCluster(3);
        this.htd = new HTableDescriptor(TableName.valueOf((String)"default", (String)"TestHBaseFsckEncryption"));
        HColumnDescriptor hcd = new HColumnDescriptor("cf");
        hcd.setEncryptionType(algorithm);
        hcd.setEncryptionKey(EncryptionUtil.wrapKey((Configuration)this.conf, (String)this.conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName()), (Key)this.cfKey));
        this.htd.addFamily(hcd);
        TEST_UTIL.getAdmin().createTable((TableDescriptor)this.htd);
        TEST_UTIL.waitTableAvailable(this.htd.getTableName(), 5000L);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFsckWithEncryption() throws Exception {
        try (Table table = TEST_UTIL.getConnection().getTable(this.htd.getTableName());){
            byte[] values = new byte[]{65, 66, 67, 68};
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values.length; ++j) {
                    Put put = new Put(new byte[]{values[i], values[j]});
                    put.addColumn(Bytes.toBytes((String)"cf"), new byte[0], new byte[]{values[i], values[j]});
                    table.put(put);
                }
            }
        }
        TEST_UTIL.getAdmin().flush(this.htd.getTableName());
        List<Path> paths = this.findStorefilePaths(this.htd.getTableName());
        Assert.assertTrue((paths.size() > 0 ? 1 : 0) != 0);
        for (Path path : paths) {
            Assert.assertTrue((String)("Store file " + path + " has incorrect key"), (boolean)Bytes.equals((byte[])this.cfKey.getEncoded(), (byte[])this.extractHFileKey(path)));
        }
        HBaseFsck res = HbckTestingUtil.doHFileQuarantine(this.conf, this.htd.getTableName());
        Assert.assertEquals((long)res.getRetCode(), (long)0L);
        HFileCorruptionChecker hfcc = res.getHFilecorruptionChecker();
        Assert.assertEquals((long)hfcc.getCorrupted().size(), (long)0L);
        Assert.assertEquals((long)hfcc.getFailures().size(), (long)0L);
        Assert.assertEquals((long)hfcc.getQuarantined().size(), (long)0L);
        Assert.assertEquals((long)hfcc.getMissing().size(), (long)0L);
    }

    private List<Path> findStorefilePaths(TableName tableName) throws Exception {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Region region : TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegions(this.htd.getTableName())) {
            for (HStore store : ((HRegion)region).getStores()) {
                for (HStoreFile storefile : store.getStorefiles()) {
                    paths.add(storefile.getPath());
                }
            }
        }
        return paths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] extractHFileKey(Path path) throws Exception {
        try (HFile.Reader reader = HFile.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)path, (CacheConfig)new CacheConfig(this.conf), (boolean)true, (Configuration)this.conf);){
            reader.loadFileInfo();
            Encryption.Context cryptoContext = reader.getFileContext().getEncryptionContext();
            Assert.assertNotNull((String)"Reader has a null crypto context", (Object)cryptoContext);
            Key key = cryptoContext.getKey();
            Assert.assertNotNull((String)"Crypto context has no key", (Object)key);
            byte[] byArray = key.getEncoded();
            return byArray;
        }
    }
}

