/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.BaseTestHBaseFsck;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HBaseFsckRepair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Ignore
@Category(value={MiscTests.class, LargeTests.class})
public class TestHBaseFsckReplicas
extends BaseTestHBaseFsck {
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().set("hbase.coprocessor.master.classes", BaseTestHBaseFsck.MasterSyncCoprocessor.class.getName());
        conf.setInt("hbase.regionserver.handler.count", 2);
        conf.setInt("hbase.regionserver.metahandler.count", 30);
        conf.setInt("hbase.htable.threads.max", 7);
        conf.setInt("hbase.hconnection.threads.max", 14);
        conf.setInt("hbase.hbck.close.timeout", 1600);
        conf.setInt("hbase.rpc.timeout", 6400);
        TEST_UTIL.startMiniCluster(3);
        tableExecutorService = new ThreadPoolExecutor(1, 7, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"testhbck"));
        hbfsckExecutorService = new ScheduledThreadPoolExecutor(7);
        AssignmentManager assignmentManager = TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager();
        regionStates = assignmentManager.getRegionStates();
        connection = (ClusterConnection)TEST_UTIL.getConnection();
        admin = connection.getAdmin();
        admin.setBalancerRunning(false, true);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.META_TABLE_NAME);
        TEST_UTIL.waitUntilAllRegionsAssigned(TableName.NAMESPACE_TABLE_NAME);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        tableExecutorService.shutdown();
        hbfsckExecutorService.shutdown();
        admin.close();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() {
        EnvironmentEdgeManager.reset();
    }

    @Test
    public void testHbckReportReplicaLingeringSplitParent() throws Exception {
        TableName table = TableName.valueOf((String)"testHbckReportReplicaLingeringSplitParent");
        try {
            this.setupTableWithRegionReplica(table, 2);
            admin.flush(table);
            admin.enableCatalogJanitor(false);
            admin.split(table, Bytes.toBytes((String)"A1"));
            Thread.sleep(1000L);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(table);
            admin.enableCatalogJanitor(true);
        }
    }

    @Test(timeout=180000L)
    public void testHbckWithRegionReplica() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTableWithRegionReplica(tableName, 2);
            admin.flush(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    @Test(timeout=180000L)
    public void testHbckWithFewerReplica() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTableWithRegionReplica(tableName, 2);
            admin.flush(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), true, false, false, false, 1);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED});
            hbck = HbckTestingUtil.doFsck(conf, true);
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testHbckWithExcessReplica() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            this.setupTableWithRegionReplica(tableName, 2);
            admin.flush(tableName);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            Table meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            List regions = admin.getRegions(tableName);
            byte[] startKey = Bytes.toBytes((String)"B");
            byte[] endKey = Bytes.toBytes((String)"C");
            byte[] metaKey = null;
            RegionInfo newHri = null;
            for (RegionInfo h : regions) {
                if (Bytes.compareTo((byte[])h.getStartKey(), (byte[])startKey) != 0 || Bytes.compareTo((byte[])h.getEndKey(), (byte[])endKey) != 0 || h.getReplicaId() != 0) continue;
                metaKey = h.getRegionName();
                newHri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)h, (int)2);
                break;
            }
            Put put = new Put(metaKey);
            Collection var = admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers();
            ServerName sn = var.toArray(new ServerName[var.size()])[0];
            MetaTableAccessor.addLocation((Put)put, (ServerName)sn, (long)sn.getStartcode(), (long)-1L, (int)2);
            meta.put(put);
            HBaseFsckRepair.fixUnassigned((Admin)admin, (RegionInfo)newHri);
            HBaseFsckRepair.waitUntilAssigned((Admin)admin, (RegionInfo)newHri);
            Delete delete = new Delete(metaKey);
            delete.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getServerColumn((int)2));
            delete.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getStartCodeColumn((int)2));
            delete.addColumns(HConstants.CATALOG_FAMILY, MetaTableAccessor.getSeqNumColumn((int)2));
            meta.delete(delete);
            meta.close();
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META});
            hbck = HbckTestingUtil.doFsck(conf, true);
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        }
        finally {
            this.cleanupTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testNotInHdfsWithReplicas() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            RegionInfo[] oldHris = new RegionInfo[2];
            this.setupTableWithRegionReplica(tableName, 2);
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            NavigableMap map = MetaTableAccessor.allTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)this.tbl.getName());
            int i = 0;
            for (Map.Entry m : map.entrySet()) {
                if (((RegionInfo)m.getKey()).getStartKey().length <= 0 || ((RegionInfo)m.getKey()).getStartKey()[0] != Bytes.toBytes((String)"B")[0]) continue;
                LOG.debug((Object)("Initially server hosting " + m.getKey() + " is " + m.getValue()));
                oldHris[i++] = (RegionInfo)m.getKey();
            }
            admin.flush(tableName);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C"), false, false, true);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_HDFS});
            HbckTestingUtil.doFsck(conf, true);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)(ROWKEYS.length - 2), (long)this.countRows());
            i = 0;
            RegionInfo[] newHris = new RegionInfo[2];
            map = MetaTableAccessor.allTableRegions((Connection)TEST_UTIL.getConnection(), (TableName)this.tbl.getName());
            for (Map.Entry m : map.entrySet()) {
                if (((RegionInfo)m.getKey()).getStartKey().length <= 0 || ((RegionInfo)m.getKey()).getStartKey()[0] != Bytes.toBytes((String)"B")[0]) continue;
                newHris[i++] = (RegionInfo)m.getKey();
            }
            Collection servers = admin.getClusterStatus(EnumSet.of(ClusterStatus.Option.LIVE_SERVERS)).getServers();
            HashSet onlineRegions = new HashSet();
            for (ServerName s : servers) {
                List list = admin.getRegions(s);
                onlineRegions.addAll(list);
            }
            Assert.assertTrue((boolean)onlineRegions.containsAll(Arrays.asList(newHris)));
            Assert.assertFalse((boolean)onlineRegions.removeAll(Arrays.asList(oldHris)));
        }
        finally {
            this.cleanupTable(tableName);
            admin.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testSplitAndDupeRegionWithRegionReplica() throws Exception {
        TableName table = TableName.valueOf((String)"testSplitAndDupeRegionWithRegionReplica");
        Table meta = null;
        try {
            this.setupTableWithRegionReplica(table, 2);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
            admin.enableCatalogJanitor(false);
            meta = connection.getTable(TableName.META_TABLE_NAME, tableExecutorService);
            HRegionLocation loc = connection.getRegionLocation(table, SPLITS[0], false);
            HRegionInfo hriParent = loc.getRegionInfo();
            connection.getAdmin().split(table, Bytes.toBytes((String)"A@"));
            Thread.sleep(1000L);
            regionStates.updateRegionState((RegionInfo)hriParent, RegionState.State.CLOSED);
            TEST_UTIL.assignRegion((RegionInfo)hriParent);
            MetaTableAccessor.addRegionToMeta((Table)meta, (RegionInfo)hriParent);
            ServerName server = regionStates.getRegionServerOfRegion((RegionInfo)hriParent);
            if (server != null) {
                TEST_UTIL.assertRegionOnServer((RegionInfo)hriParent, server, 800L);
            }
            while (this.findDeployedHSI(this.getDeployedHRIs((Admin)((HBaseAdmin)admin)), (RegionInfo)hriParent) == null) {
                Thread.sleep(250L);
            }
            LOG.debug((Object)"Finished assignment of parent region");
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
            hbck = new HBaseFsck(conf, (ExecutorService)hbfsckExecutorService);
            hbck.setDisplayFullReport();
            hbck.setTimeLag(0L);
            hbck.setFixHdfsOverlaps(true);
            hbck.setRemoveParents(true);
            hbck.setFixReferenceFiles(true);
            hbck.setFixHFileLinks(true);
            hbck.connect();
            hbck.onlineHbck();
            hbck.close();
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
            Assert.assertEquals((long)ROWKEYS.length, (long)this.countRows());
        }
        finally {
            this.cleanupTable(table);
        }
    }
}

