/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, MediumTests.class})
public class TestOfflineMetaRebuildBase
extends OfflineMetaRebuildTestCore {
    private static final Log LOG = LogFactory.getLog(TestOfflineMetaRebuildBase.class);

    @Ignore
    @Test(timeout=120000L)
    public void testMetaRebuild() throws Exception {
        this.wipeOutMeta();
        Assert.assertEquals((long)1L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertTrue((boolean)fsck.rebuildMeta(false));
        Assert.assertTrue((String)"HBCK meta recovery WAL directory exist.", (boolean)this.validateHBCKMetaRecoveryWALDir());
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)this.TEST_UTIL.getConfiguration());){
            TableName[] tableNames;
            Admin admin = connection.getAdmin();
            if (admin.isTableDisabled(this.table)) {
                admin.enableTable(this.table);
            }
            LOG.info((Object)"Waiting for no more RIT");
            this.TEST_UTIL.waitUntilNoRegionsInTransition(60000L);
            LOG.info((Object)"No more RIT in ZK, now doing final test verification");
            Assert.assertEquals((long)5L, (long)this.scanMeta());
            for (TableName tableName : tableNames = this.TEST_UTIL.getAdmin().listTableNames()) {
                HTableDescriptor tableDescriptor = this.TEST_UTIL.getAdmin().getTableDescriptor(tableName);
                Assert.assertNotNull((Object)tableDescriptor);
                Assert.assertTrue((boolean)this.TEST_UTIL.getAdmin().isTableEnabled(tableName));
            }
            Object[] htbls = admin.listTables();
            LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
            Assert.assertEquals((long)1L, (long)htbls.length);
        }
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[0]);
        LOG.info((Object)("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries."));
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
    }

    private boolean validateHBCKMetaRecoveryWALDir() throws IOException {
        Path rootdir = FSUtils.getRootDir((Configuration)this.TEST_UTIL.getConfiguration());
        Path walLogDir = new Path(rootdir, "WALs");
        FileSystem fs = this.TEST_UTIL.getTestFileSystem();
        FileStatus[] walFiles = FSUtils.listStatus((FileSystem)fs, (Path)walLogDir, null);
        Assert.assertNotNull((Object)walFiles);
        for (FileStatus fsStat : walFiles) {
            if (!fsStat.isDirectory() || !fsStat.getPath().getName().startsWith("hbck-meta-recovery-")) continue;
            return false;
        }
        return true;
    }
}

