/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.test;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.util.LoadTestKVGenerator;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class LoadTestDataGenerator {
    protected LoadTestKVGenerator kvGenerator;
    public static final byte[] MUTATE_INFO = "mutate_info".getBytes();
    public static final byte[] INCREMENT = "increment".getBytes();
    protected String[] args;

    public LoadTestDataGenerator() {
    }

    public LoadTestDataGenerator(int minValueSize, int maxValueSize) {
        this.kvGenerator = new LoadTestKVGenerator(minValueSize, maxValueSize);
    }

    public static byte[] generateData(Random r, int length) {
        byte[] b = new byte[length];
        int i = 0;
        for (i = 0; i < length - 8; i += 8) {
            b[i] = (byte)(65 + r.nextInt(26));
            b[i + 1] = b[i];
            b[i + 2] = b[i];
            b[i + 3] = b[i];
            b[i + 4] = b[i];
            b[i + 5] = b[i];
            b[i + 6] = b[i];
            b[i + 7] = b[i];
        }
        byte a = (byte)(65 + r.nextInt(26));
        while (i < length) {
            b[i] = a;
            ++i;
        }
        return b;
    }

    public void initialize(String[] args) {
        this.args = args;
    }

    public abstract byte[] getDeterministicUniqueKey(long var1);

    public abstract byte[][] getColumnFamilies();

    public abstract byte[][] generateColumnsForCf(byte[] var1, byte[] var2);

    public abstract byte[] generateValue(byte[] var1, byte[] var2, byte[] var3);

    public abstract boolean verify(byte[] var1, byte[] var2, Set<byte[]> var3);

    public abstract boolean verify(byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    public Mutation beforeMutate(long rowkeyBase, Mutation m) throws IOException {
        return m;
    }

    public Get beforeGet(long rowkeyBase, Get get) throws IOException {
        return get;
    }

    public String[] getArgs() {
        return this.args;
    }
}

