/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.test;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.util.MultiThreadedAction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class LoadTestDataGeneratorWithACL
extends MultiThreadedAction.DefaultDataGenerator {
    private static final Log LOG = LogFactory.getLog(LoadTestDataGeneratorWithACL.class);
    private String[] userNames = null;
    private static final String COMMA = ",";
    private int specialPermCellInsertionFactor = 100;

    public LoadTestDataGeneratorWithACL(int minValueSize, int maxValueSize, int minColumnsPerKey, int maxColumnsPerKey, byte[] ... columnFamilies) {
        super(minValueSize, maxValueSize, minColumnsPerKey, maxColumnsPerKey, columnFamilies);
    }

    @Override
    public void initialize(String[] args) {
        super.initialize(args);
        if (args.length != 3) {
            throw new IllegalArgumentException("LoadTestDataGeneratorWithACL can have 1st arguement which would be super user, the 2nd argument would be the user list and the 3rd argument should be the factor representing the row keys for which only write ACLs will be added.");
        }
        String temp = args[1];
        this.userNames = temp.split(COMMA);
        this.specialPermCellInsertionFactor = Integer.parseInt(args[2]);
    }

    @Override
    public Mutation beforeMutate(long rowkeyBase, Mutation m) throws IOException {
        if (!(m instanceof Delete) && this.userNames != null && this.userNames.length > 0) {
            int mod = (int)rowkeyBase % this.userNames.length;
            if ((int)rowkeyBase % this.specialPermCellInsertionFactor == 0) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Adding special perm " + rowkeyBase));
                }
                m.setACL(this.userNames[mod], new Permission(new Permission.Action[]{Permission.Action.WRITE}));
            } else {
                m.setACL(this.userNames[mod], new Permission(new Permission.Action[]{Permission.Action.READ}));
            }
        }
        return m;
    }
}

