/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ServiceException;
import org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestWALFiltering {
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 4;
    private static final TableName TABLE_NAME = TableName.valueOf((String)"TestWALFiltering");
    private static final byte[] CF1 = Bytes.toBytes((String)"MyCF1");
    private static final byte[] CF2 = Bytes.toBytes((String)"MyCF2");
    private static final byte[][] FAMILIES = new byte[][]{CF1, CF2};
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Before
    public void setUp() throws Exception {
        this.TEST_UTIL.startMiniCluster(1, 4);
        this.fillTable();
    }

    @After
    public void tearDown() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    private void fillTable() throws IOException, InterruptedException {
        Table table = this.TEST_UTIL.createTable(TABLE_NAME, FAMILIES, 3, Bytes.toBytes((String)"row0"), Bytes.toBytes((String)"row99"), 4);
        Random rand = new Random(19387129L);
        for (int iStoreFile = 0; iStoreFile < 4; ++iStoreFile) {
            for (int iRow = 0; iRow < 100; ++iRow) {
                byte[] row = Bytes.toBytes((String)("row" + iRow));
                Put put = new Put(row);
                Delete del = new Delete(row);
                for (int iCol = 0; iCol < 10; ++iCol) {
                    byte[] cf = rand.nextBoolean() ? CF1 : CF2;
                    long ts = Math.abs(rand.nextInt());
                    byte[] qual = Bytes.toBytes((String)("col" + iCol));
                    if (rand.nextBoolean()) {
                        byte[] value = Bytes.toBytes((String)("value_for_row_" + iRow + "_cf_" + Bytes.toStringBinary((byte[])cf) + "_col_" + iCol + "_ts_" + ts + "_random_" + rand.nextLong()));
                        put.addColumn(cf, qual, ts, value);
                        continue;
                    }
                    if (rand.nextDouble() < 0.8) {
                        del.addColumn(cf, qual, ts);
                        continue;
                    }
                    del.addColumn(cf, qual, ts);
                }
                table.put(put);
                table.delete(del);
            }
        }
        this.TEST_UTIL.waitUntilAllRegionsAssigned(TABLE_NAME);
    }

    @Test
    public void testFlushedSequenceIdsSentToHMaster() throws IOException, InterruptedException, ServiceException, com.google.protobuf.ServiceException {
        TreeMap allFlushedSequenceIds = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < 4; ++i) {
            this.flushAllRegions(i);
        }
        Thread.sleep(10000L);
        HMaster master = this.TEST_UTIL.getMiniHBaseCluster().getMaster();
        for (int i = 0; i < 4; ++i) {
            for (byte[] regionName : this.getRegionsByServer(i)) {
                if (!allFlushedSequenceIds.containsKey(regionName)) continue;
                RegionServerStatusProtos.GetLastFlushedSequenceIdRequest req = RequestConverter.buildGetLastFlushedSequenceIdRequest((byte[])regionName);
                Assert.assertEquals((long)((Long)allFlushedSequenceIds.get(regionName)), (long)master.getMasterRpcServices().getLastFlushedSequenceId(null, req).getLastFlushedSequenceId());
            }
        }
    }

    private List<byte[]> getRegionsByServer(int rsId) throws IOException {
        ArrayList regionNames = Lists.newArrayList();
        HRegionServer hrs = this.getRegionServer(rsId);
        for (Region r : hrs.getRegions(TABLE_NAME)) {
            regionNames.add(r.getRegionInfo().getRegionName());
        }
        return regionNames;
    }

    private HRegionServer getRegionServer(int rsId) {
        return this.TEST_UTIL.getMiniHBaseCluster().getRegionServer(rsId);
    }

    private void flushAllRegions(int rsId) throws com.google.protobuf.ServiceException, ServiceException, IOException {
        HRegionServer hrs = this.getRegionServer(rsId);
        for (byte[] regionName : this.getRegionsByServer(rsId)) {
            AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest((byte[])regionName);
            hrs.getRSRpcServices().flushRegion(null, request);
        }
    }
}

