/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.charset.CharacterCodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyHiveDecimalObjectInspector;
import org.apache.hadoop.io.Text;

public class LazyHiveDecimal
extends LazyPrimitive<LazyHiveDecimalObjectInspector, HiveDecimalWritable> {
    private static final Log LOG = LogFactory.getLog(LazyHiveDecimal.class);

    public LazyHiveDecimal(LazyHiveDecimalObjectInspector oi) {
        super(oi);
        this.data = new HiveDecimalWritable();
    }

    public LazyHiveDecimal(LazyHiveDecimal copy) {
        super(copy);
        this.data = new HiveDecimalWritable((HiveDecimalWritable)copy.data);
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        try {
            byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            ((HiveDecimalWritable)this.data).set(new HiveDecimal(byteData));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            LOG.debug((Object)("Data not in the HiveDecimal data type range so converted to null. Given data is :" + byteData), (Throwable)e);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug((Object)"Data not in the HiveDecimal data type range so converted to null.", (Throwable)e);
        }
    }

    @Override
    public HiveDecimalWritable getWritableObject() {
        return (HiveDecimalWritable)this.data;
    }
}

