/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.execchain;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.impl.execchain.ServiceUnavailableRetryExec;
import org.apache.http.protocol.HttpContext;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestServiceUnavailableRetryExec {
    @Mock
    private ClientExecChain requestExecutor;
    @Mock
    private ServiceUnavailableRetryStrategy retryStrategy;
    @Mock
    private HttpExecutionAware execAware;
    private ServiceUnavailableRetryExec retryExec;
    private HttpHost target;

    @Before
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.retryExec = new ServiceUnavailableRetryExec(this.requestExecutor, this.retryStrategy);
        this.target = new HttpHost("localhost", 80);
    }

    @Test
    public void testFundamentals() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet get = new HttpGet("/test");
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)get);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.retryStrategy.getRetryInterval()).thenReturn((Object)0L);
        this.retryExec.execute(route, request, context, this.execAware);
        ((ClientExecChain)Mockito.verify((Object)this.requestExecutor, (VerificationMode)Mockito.times((int)2))).execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.same((Object)request), (HttpClientContext)Mockito.same((Object)context), (HttpExecutionAware)Mockito.same((Object)this.execAware));
        ((CloseableHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test(expected=RuntimeException.class)
    public void testStrategyRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)new HttpGet("/test"));
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        ((ServiceUnavailableRetryStrategy)Mockito.doThrow((Throwable)new RuntimeException("Ooopsie")).when((Object)this.retryStrategy)).retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any());
        try {
            this.retryExec.execute(route, request, context, this.execAware);
        }
        catch (Exception ex) {
            ((CloseableHttpResponse)Mockito.verify((Object)response)).close();
            throw ex;
        }
    }

    @Test
    public void testNonRepeatableEntityResponseReturnedImmediately() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpEntity entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)entity.isRepeatable()).thenReturn((Object)Boolean.FALSE);
        HttpPut put = new HttpPut("/test");
        put.setEntity(entity);
        HttpRequestWrapper request = HttpRequestWrapper.wrap((HttpRequest)put);
        HttpClientContext context = HttpClientContext.create();
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.requestExecutor.execute((HttpRoute)Mockito.eq((Object)route), (HttpRequestWrapper)Mockito.any(), (HttpClientContext)Mockito.any(), (HttpExecutionAware)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.retryExec.execute(route, request, context, this.execAware);
        ((CloseableHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).close();
    }
}

