/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.OrcMetrics;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;

public class TableMigrationUtil {
    private static final PathFilter HIDDEN_PATH_FILTER = p -> !p.getName().startsWith("_") && !p.getName().startsWith(".");

    private TableMigrationUtil() {
    }

    public static List<DataFile> listPartition(Map<String, String> partition, String uri, String format, PartitionSpec spec, Configuration conf, MetricsConfig metricsConfig, NameMapping mapping) {
        if (format.contains("avro")) {
            return TableMigrationUtil.listAvroPartition(partition, uri, spec, conf);
        }
        if (format.contains("parquet")) {
            return TableMigrationUtil.listParquetPartition(partition, uri, spec, conf, metricsConfig, mapping);
        }
        if (format.contains("orc")) {
            return TableMigrationUtil.listOrcPartition(partition, uri, spec, conf, metricsConfig, mapping);
        }
        throw new UnsupportedOperationException("Unknown partition format: " + format);
    }

    private static List<DataFile> listAvroPartition(Map<String, String> partitionPath, String partitionUri, PartitionSpec spec, Configuration conf) {
        try {
            Path partition = new Path(partitionUri);
            FileSystem fs = partition.getFileSystem(conf);
            return Arrays.stream(fs.listStatus(partition, HIDDEN_PATH_FILTER)).filter(FileStatus::isFile).map(stat -> {
                HadoopInputFile file = HadoopInputFile.fromLocation((CharSequence)stat.getPath().toString(), (Configuration)conf);
                long rowCount = Avro.rowCount((InputFile)file);
                Metrics metrics = new Metrics(Long.valueOf(rowCount), null, null, null);
                String partitionKey = spec.fields().stream().map(PartitionField::name).map(name -> String.format("%s=%s", name, partitionPath.get(name))).collect(Collectors.joining("/"));
                return DataFiles.builder((PartitionSpec)spec).withPath(stat.getPath().toString()).withFormat("avro").withFileSizeInBytes(stat.getLen()).withMetrics(metrics).withPartitionPath(partitionKey).build();
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in partition: " + partitionUri, e);
        }
    }

    private static List<DataFile> listParquetPartition(Map<String, String> partitionPath, String partitionUri, PartitionSpec spec, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            Path partition = new Path(partitionUri);
            FileSystem fs = partition.getFileSystem(conf);
            return Arrays.stream(fs.listStatus(partition, HIDDEN_PATH_FILTER)).filter(FileStatus::isFile).map(stat -> {
                Metrics metrics;
                try {
                    ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)conf, (FileStatus)stat);
                    metrics = ParquetUtil.footerMetrics((ParquetMetadata)metadata, Stream.empty(), (MetricsConfig)metricsSpec, (NameMapping)mapping);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read the footer of the parquet file: " + stat.getPath(), e);
                }
                String partitionKey = spec.fields().stream().map(PartitionField::name).map(name -> String.format("%s=%s", name, partitionPath.get(name))).collect(Collectors.joining("/"));
                return DataFiles.builder((PartitionSpec)spec).withPath(stat.getPath().toString()).withFormat("parquet").withFileSizeInBytes(stat.getLen()).withMetrics(metrics).withPartitionPath(partitionKey).build();
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in partition: " + partitionUri, e);
        }
    }

    private static List<DataFile> listOrcPartition(Map<String, String> partitionPath, String partitionUri, PartitionSpec spec, Configuration conf, MetricsConfig metricsSpec, NameMapping mapping) {
        try {
            Path partition = new Path(partitionUri);
            FileSystem fs = partition.getFileSystem(conf);
            return Arrays.stream(fs.listStatus(partition, HIDDEN_PATH_FILTER)).filter(FileStatus::isFile).map(stat -> {
                Metrics metrics = OrcMetrics.fromInputFile((InputFile)HadoopInputFile.fromPath((Path)stat.getPath(), (Configuration)conf), (MetricsConfig)metricsSpec, (NameMapping)mapping);
                String partitionKey = spec.fields().stream().map(PartitionField::name).map(name -> String.format("%s=%s", name, partitionPath.get(name))).collect(Collectors.joining("/"));
                return DataFiles.builder((PartitionSpec)spec).withPath(stat.getPath().toString()).withFormat("orc").withFileSizeInBytes(stat.getLen()).withMetrics(metrics).withPartitionPath(partitionKey).build();
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to list files in partition: " + partitionUri, e);
        }
    }
}

