/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableSortedMap;
import java.util.Date;
import java.util.SortedMap;
import java.util.UUID;
import javax.mail.Flags;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Username;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EventTest {
    private static final UUID UUID_1 = UUID.fromString("6e0dd59d-660e-4d9b-b22f-0354479f47b4");
    public static final Username BOB = Username.of((String)"BOB");

    EventTest() {
    }

    @Test
    void eventIdShouldMatchBeanContract() {
        EqualsVerifier.forClass(Event.EventId.class).verify();
    }

    @Test
    void ofShouldDeserializeUUIDs() {
        Assertions.assertThat((Object)Event.EventId.of((String)UUID_1.toString())).isEqualTo((Object)Event.EventId.of((UUID)UUID_1));
    }

    @Test
    void getMessageIdsShouldReturnEmptyWhenAddedEmpty() {
        MailboxEvents.Added added = new MailboxEvents.Added(MailboxSession.SessionId.of((long)36L), BOB, MailboxPath.inbox((Username)BOB), (MailboxId)TestId.of(48L), (SortedMap)ImmutableSortedMap.of(), Event.EventId.of((UUID)UUID_1));
        Assertions.assertThat((Iterable)added.getMessageIds()).isEmpty();
    }

    @Test
    void getMessageIdsShouldReturnDistinctValues() {
        MessageUid uid1 = MessageUid.of((long)36L);
        MessageUid uid2 = MessageUid.of((long)37L);
        TestMessageId messageId1 = TestMessageId.of(45L);
        TestMessageId messageId2 = TestMessageId.of(46L);
        MessageMetaData metaData1 = new MessageMetaData(uid1, ModSeq.of((long)85L), new Flags(), 36L, new Date(), (MessageId)messageId1);
        MessageMetaData metaData2 = new MessageMetaData(uid2, ModSeq.of((long)85L), new Flags(), 36L, new Date(), (MessageId)messageId2);
        MailboxEvents.Added added = new MailboxEvents.Added(MailboxSession.SessionId.of((long)36L), BOB, MailboxPath.inbox((Username)BOB), (MailboxId)TestId.of(48L), (SortedMap)ImmutableSortedMap.of((Comparable)uid1, (Object)metaData1, (Comparable)uid2, (Object)metaData2), Event.EventId.of((UUID)UUID_1));
        Assertions.assertThat((Iterable)added.getMessageIds()).containsOnly((Object[])new MessageId[]{messageId1, messageId2});
    }

    @Test
    void getMessageIdsShouldNotReturnDuplicates() {
        MessageUid uid1 = MessageUid.of((long)36L);
        MessageUid uid2 = MessageUid.of((long)37L);
        TestMessageId messageId = TestMessageId.of(45L);
        MessageMetaData metaData1 = new MessageMetaData(uid1, ModSeq.of((long)85L), new Flags(), 36L, new Date(), (MessageId)messageId);
        MessageMetaData metaData2 = new MessageMetaData(uid2, ModSeq.of((long)85L), new Flags(), 36L, new Date(), (MessageId)messageId);
        MailboxEvents.Added added = new MailboxEvents.Added(MailboxSession.SessionId.of((long)36L), BOB, MailboxPath.inbox((Username)BOB), (MailboxId)TestId.of(48L), (SortedMap)ImmutableSortedMap.of((Comparable)uid1, (Object)metaData1, (Comparable)uid2, (Object)metaData2), Event.EventId.of((UUID)UUID_1));
        Assertions.assertThat((Iterable)added.getMessageIds()).containsExactly((Object[])new MessageId[]{messageId});
    }
}

