/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import javax.mail.Flags;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.events.Event;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.Quota;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.model.TestId;
import org.apache.james.mailbox.model.TestMessageId;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxListenerTest {
    private static final MailboxPath PATH = MailboxPath.forUser((Username)Username.of((String)"bob"), (String)"mailbox");
    private static final MailboxPath OTHER_PATH = MailboxPath.forUser((Username)Username.of((String)"bob"), (String)"mailbox.other");
    private static final Username BOB = Username.of((String)"bob");
    private static final MailboxSession.SessionId SESSION_ID = MailboxSession.SessionId.of((long)42L);
    private static final TestId MAILBOX_ID = TestId.of(18L);
    private static final QuotaRoot QUOTA_ROOT = QuotaRoot.quotaRoot((String)"bob", Optional.empty());
    private static final QuotaCountUsage QUOTA_COUNT = QuotaCountUsage.count((long)34L);
    private static final QuotaSizeUsage QUOTA_SIZE = QuotaSizeUsage.size((long)48L);
    private static final MailboxACL ACL_1 = new MailboxACL(new Map.Entry[]{Pair.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)Username.of((String)"Bob")), (Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}))});
    private static final MailboxACL ACL_2 = new MailboxACL(new Map.Entry[]{Pair.of((Object)MailboxACL.EntryKey.createUserEntryKey((Username)Username.of((String)"Bob")), (Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Read}))});
    private static final MessageUid UID = MessageUid.of((long)85L);
    private static final MessageMetaData META_DATA = new MessageMetaData(UID, ModSeq.of((long)45L), new Flags(), 45L, new Date(), (MessageId)TestMessageId.of(75L));

    MailboxListenerTest() {
    }

    @Test
    void mailboxAddedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.MailboxAdded.class).verify();
    }

    @Test
    void mailboxRenamedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.MailboxRenamed.class).verify();
    }

    @Test
    void mailboxDeletionShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.MailboxDeletion.class).verify();
    }

    @Test
    void mailboxACLUpdatedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.MailboxACLUpdated.class).verify();
    }

    @Test
    void addedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.Added.class).verify();
    }

    @Test
    void expungedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.Expunged.class).verify();
    }

    @Test
    void flagUpdatedShouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxEvents.FlagsUpdated.class).verify();
    }

    @Test
    void renameWithSameNameShouldBeNoop() {
        MailboxEvents.MailboxRenamed mailboxRenamed = new MailboxEvents.MailboxRenamed(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, PATH, Event.EventId.random());
        Assertions.assertThat((boolean)mailboxRenamed.isNoop()).isTrue();
    }

    @Test
    void renameWithDifferentNameShouldNotBeNoop() {
        MailboxEvents.MailboxRenamed mailboxRenamed = new MailboxEvents.MailboxRenamed(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, OTHER_PATH, Event.EventId.random());
        Assertions.assertThat((boolean)mailboxRenamed.isNoop()).isFalse();
    }

    @Test
    void addedShouldNotBeNoop() {
        MailboxEvents.MailboxAdded added = new MailboxEvents.MailboxAdded(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, Event.EventId.random());
        Assertions.assertThat((boolean)added.isNoop()).isFalse();
    }

    @Test
    void removedShouldNotBeNoop() {
        MailboxEvents.MailboxDeletion deletion = new MailboxEvents.MailboxDeletion(SESSION_ID, BOB, PATH, new MailboxACL(), QUOTA_ROOT, QUOTA_COUNT, QUOTA_SIZE, (MailboxId)MAILBOX_ID, Event.EventId.random());
        Assertions.assertThat((boolean)deletion.isNoop()).isFalse();
    }

    @Test
    void aclDiffWithSameAclShouldBeNoop() {
        MailboxEvents.MailboxACLUpdated aclUpdated = new MailboxEvents.MailboxACLUpdated(SESSION_ID, BOB, PATH, ACLDiff.computeDiff((MailboxACL)ACL_1, (MailboxACL)ACL_1), (MailboxId)MAILBOX_ID, Event.EventId.random());
        Assertions.assertThat((boolean)aclUpdated.isNoop()).isTrue();
    }

    @Test
    void aclDiffWithDifferentAclShouldNotBeNoop() {
        MailboxEvents.MailboxACLUpdated aclUpdated = new MailboxEvents.MailboxACLUpdated(SESSION_ID, BOB, PATH, ACLDiff.computeDiff((MailboxACL)ACL_1, (MailboxACL)ACL_2), (MailboxId)MAILBOX_ID, Event.EventId.random());
        Assertions.assertThat((boolean)aclUpdated.isNoop()).isFalse();
    }

    @Test
    void addedShouldBeNoopWhenEmpty() {
        MailboxEvents.Added added = new MailboxEvents.Added(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (SortedMap)ImmutableSortedMap.of(), Event.EventId.random());
        Assertions.assertThat((boolean)added.isNoop()).isTrue();
    }

    @Test
    void addedShouldNotBeNoopWhenNotEmpty() {
        MailboxEvents.Added added = new MailboxEvents.Added(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (SortedMap)ImmutableSortedMap.of((Comparable)UID, (Object)META_DATA), Event.EventId.random());
        Assertions.assertThat((boolean)added.isNoop()).isFalse();
    }

    @Test
    void expungedShouldBeNoopWhenEmpty() {
        MailboxEvents.Expunged expunged = new MailboxEvents.Expunged(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (Map)ImmutableSortedMap.of(), Event.EventId.random());
        Assertions.assertThat((boolean)expunged.isNoop()).isTrue();
    }

    @Test
    void expungedShouldNotBeNoopWhenNotEmpty() {
        MailboxEvents.Expunged expunged = new MailboxEvents.Expunged(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (Map)ImmutableSortedMap.of((Comparable)UID, (Object)META_DATA), Event.EventId.random());
        Assertions.assertThat((boolean)expunged.isNoop()).isFalse();
    }

    @Test
    void flagsUpdatedShouldBeNoopWhenEmpty() {
        MailboxEvents.FlagsUpdated flagsUpdated = new MailboxEvents.FlagsUpdated(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (List)ImmutableList.of(), Event.EventId.random());
        Assertions.assertThat((boolean)flagsUpdated.isNoop()).isTrue();
    }

    @Test
    void flagsUpdatedShouldNotBeNoopWhenNotEmpty() {
        MailboxEvents.FlagsUpdated flagsUpdated = new MailboxEvents.FlagsUpdated(SESSION_ID, BOB, PATH, (MailboxId)MAILBOX_ID, (List)ImmutableList.of((Object)UpdatedFlags.builder().uid(UID).modSeq(ModSeq.of((long)45L)).newFlags(new Flags()).oldFlags(new Flags(Flags.Flag.ANSWERED)).build()), Event.EventId.random());
        Assertions.assertThat((boolean)flagsUpdated.isNoop()).isFalse();
    }

    @Test
    void quotaUsageUpdatedEventShouldNotBeNoop() {
        MailboxEvents.QuotaUsageUpdatedEvent event = new MailboxEvents.QuotaUsageUpdatedEvent(Event.EventId.random(), BOB, QUOTA_ROOT, Quota.builder().used((QuotaUsageValue)QUOTA_COUNT).computedLimit((QuotaLimitValue)QuotaCountLimit.unlimited()).build(), Quota.builder().used((QuotaUsageValue)QUOTA_SIZE).computedLimit((QuotaLimitValue)QuotaSizeLimit.unlimited()).build(), Instant.now());
        Assertions.assertThat((boolean)event.isNoop()).isFalse();
    }
}

