/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import com.google.common.collect.ImmutableSet;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.core.Username;
import org.apache.james.events.EventBus;
import org.apache.james.events.RegistrationKey;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface MailboxManagerStressContract<T extends MailboxManager> {
    public static final int APPEND_OPERATIONS = 200;

    public T getManager();

    public EventBus retrieveEventBus();

    @Test
    default public void testStressTest() throws InterruptedException, MailboxException {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        CountDownLatch latch = new CountDownLatch(200);
        ExecutorService pool = Executors.newFixedThreadPool(10, (ThreadFactory)threadFactory);
        ConcurrentLinkedDeque uList = new ConcurrentLinkedDeque();
        Username username = Username.of((String)"username");
        MailboxSession session = this.getManager().createSystemSession(username);
        this.getManager().startProcessingRequest(session);
        MailboxPath path = MailboxPath.forUser((Username)username, (String)"INBOX");
        MailboxId mailboxId = (MailboxId)this.getManager().createMailbox(path, session).get();
        Mono.from((Publisher)this.retrieveEventBus().register(event -> {
            MessageUid u = (MessageUid)((MailboxEvents.Added)event).getUids().iterator().next();
            uList.add(u);
        }, (RegistrationKey)new MailboxIdRegistrationKey(mailboxId))).block();
        this.getManager().endProcessingRequest(session);
        this.getManager().logout(session);
        AtomicBoolean fail = new AtomicBoolean(false);
        ConcurrentHashMap uids = new ConcurrentHashMap();
        for (int i = 0; i < 200; ++i) {
            pool.execute(() -> {
                if (fail.get()) {
                    latch.countDown();
                    return;
                }
                try {
                    MailboxSession mailboxSession = this.getManager().createSystemSession(username);
                    this.getManager().startProcessingRequest(mailboxSession);
                    MessageManager m = this.getManager().getMailbox(path, mailboxSession);
                    ComposedMessageId messageId = m.appendMessage(MessageManager.AppendCommand.from((Message.Builder)Message.Builder.of().setSubject("test").setBody("testmail", StandardCharsets.UTF_8)), mailboxSession).getId();
                    if (uids.put(messageId.getUid(), new Object()) != null) {
                        fail.set(true);
                    }
                    this.getManager().endProcessingRequest(mailboxSession);
                    this.getManager().logout(mailboxSession);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fail.set(true);
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await(10L, TimeUnit.MINUTES);
        Assertions.assertThat((int)ImmutableSet.copyOf(uList).size()).isEqualTo(200);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)fail.get()).describedAs("Unable to append all messages", new Object[0])).isFalse();
        pool.shutdown();
    }
}

