/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import org.apache.james.mailbox.MessageUid;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageUidTest {
    private static final MessageUid _1 = MessageUid.of((long)1L);
    private static final MessageUid _2 = MessageUid.of((long)2L);
    private static final MessageUid _3 = MessageUid.of((long)3L);
    private static final MessageUid _4 = MessageUid.of((long)4L);

    MessageUidTest() {
    }

    @Test
    void distanceShouldReturnZeroWhenSameValue() {
        Assertions.assertThat((long)_1.distance(_1)).isEqualTo(0L);
    }

    @Test
    void distanceShouldThrowWhenNullArgument() {
        Assertions.assertThatThrownBy(() -> _1.distance(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void distanceShouldReturnPositiveDistanceWhenGreaterArgument() {
        Assertions.assertThat((long)_1.distance(_4)).isEqualTo(3L);
    }

    @Test
    void distanceShouldReturnNegativeDistanceWhenSmallerArgument() {
        Assertions.assertThat((long)_3.distance(_2)).isEqualTo(-1L);
    }
}

