/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox;

import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MailboxSessionUtil;
import org.apache.james.mailbox.SubscriptionManager;
import org.apache.james.mailbox.exception.SubscriptionException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface SubscriptionManagerContract {
    public static final Username USER1 = Username.of((String)"test");
    public static final String MAILBOX1 = "test1";
    public static final String MAILBOX2 = "test2";
    public static final MailboxSession SESSION = MailboxSessionUtil.create(USER1);

    public SubscriptionManager getSubscriptionManager();

    @Test
    default public void user1ShouldNotHaveAnySubscriptionByDefault() throws SubscriptionException {
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).isEmpty();
    }

    @Test
    default public void user1ShouldBeAbleToSubscribeOneMailbox() throws SubscriptionException {
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).containsExactly((Object[])new String[]{MAILBOX1});
    }

    @Test
    default public void subscribeShouldBeIdempotent() throws SubscriptionException {
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).containsExactly((Object[])new String[]{MAILBOX1});
    }

    @Test
    default public void user1ShouldBeAbleToSubscribeTwoMailbox() throws SubscriptionException {
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX2);
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).containsOnly((Object[])new String[]{MAILBOX1, MAILBOX2});
    }

    @Test
    default public void user1ShouldBeAbleToUnsubscribeOneMailbox() throws SubscriptionException {
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX2);
        this.getSubscriptionManager().unsubscribe(SESSION, MAILBOX1);
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).containsExactly((Object[])new String[]{MAILBOX2});
    }

    @Test
    default public void unsubscribeShouldBeIdempotent() throws SubscriptionException {
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX1);
        this.getSubscriptionManager().subscribe(SESSION, MAILBOX2);
        this.getSubscriptionManager().unsubscribe(SESSION, MAILBOX1);
        this.getSubscriptionManager().unsubscribe(SESSION, MAILBOX1);
        Assertions.assertThat((Iterable)this.getSubscriptionManager().subscriptions(SESSION)).containsExactly((Object[])new String[]{MAILBOX2});
    }
}

