/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.stream.Stream;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ACLDiffTest {
    private static final MailboxACL.EntryKey ENTRY_KEY = MailboxACL.EntryKey.createGroupEntryKey((String)"any", (boolean)false);
    private static final MailboxACL.Rfc4314Rights RIGHTS = new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Administer});

    ACLDiffTest() {
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenSameACL() {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.addedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition());
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)aclDiff.addedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenSameACL() {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.removedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition());
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)aclDiff.removedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenSameACL() {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.changedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenSameNonEmptyACL() throws UnsupportedRightException {
        MailboxACL mailboxACL = MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition());
        ACLDiff acldiff = ACLDiff.computeDiff((MailboxACL)mailboxACL, (MailboxACL)mailboxACL);
        Assertions.assertThat((Stream)acldiff.changedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnNewEntryWhenAddedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)aclDiff.addedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(ENTRY_KEY, RIGHTS)});
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenAddedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)aclDiff.changedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenAddedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY, (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()));
        Assertions.assertThat((Stream)aclDiff.removedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenRemovedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.addedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEmptyWhenRemovedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.changedEntries()).isEmpty();
    }

    @Test
    void removedEntriesShouldReturnEntryWhenRemovedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY);
        Assertions.assertThat((Stream)aclDiff.removedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(ENTRY_KEY, RIGHTS)});
    }

    @Test
    void removedEntriesShouldReturnEmptyWhenChangedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)aclDiff.removedEntries()).isEmpty();
    }

    @Test
    void addedEntriesShouldReturnEmptyWhenChangedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(RIGHTS).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)aclDiff.addedEntries()).isEmpty();
    }

    @Test
    void changedEntriesShouldReturnEntryWhenChangedEntry() throws Exception {
        ACLDiff aclDiff = ACLDiff.computeDiff((MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Administer}).asAddition()), (MailboxACL)MailboxACL.EMPTY.apply(MailboxACL.command().key(ENTRY_KEY).rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).asAddition()));
        Assertions.assertThat((Stream)aclDiff.changedEntries()).containsOnly((Object[])new MailboxACL.Entry[]{new MailboxACL.Entry(ENTRY_KEY, new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}))});
    }
}

