/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SimpleGroupMembershipResolverTest {
    private static final Username USER = Username.of((String)"user");
    private SimpleGroupMembershipResolver simpleGroupMembershipResolver;

    SimpleGroupMembershipResolverTest() {
    }

    @BeforeEach
    void setUp() {
        this.simpleGroupMembershipResolver = new SimpleGroupMembershipResolver();
    }

    @Test
    void isMemberShouldReturnFalseWhenEmptyResolver() {
        boolean actual = this.simpleGroupMembershipResolver.isMember(USER, "group");
        Assertions.assertThat((boolean)actual).isFalse();
    }

    @Test
    void isMemberShouldReturnTrueWhenTheSearchedMembershipIsPresent() {
        this.simpleGroupMembershipResolver.addMembership("group", USER);
        boolean actual = this.simpleGroupMembershipResolver.isMember(USER, "group");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void addMembershipShouldAddAMembershipWhenNonNullUser() {
        this.simpleGroupMembershipResolver.addMembership("group", USER);
        boolean actual = this.simpleGroupMembershipResolver.isMember(USER, "group");
        Assertions.assertThat((boolean)actual).isTrue();
    }

    @Test
    void addMembershipShouldAddAMembershipWithANullUser() {
        Username userAdded = null;
        this.simpleGroupMembershipResolver.addMembership("group", userAdded);
        boolean actual = this.simpleGroupMembershipResolver.isMember(userAdded, "group");
        Assertions.assertThat((boolean)actual).isTrue();
    }
}

