/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.acl;

import java.util.Map;
import org.apache.james.core.Username;
import org.apache.james.mailbox.acl.GroupMembershipResolver;
import org.apache.james.mailbox.acl.SimpleGroupMembershipResolver;
import org.apache.james.mailbox.acl.UnionMailboxACLResolver;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class UnionMailboxACLResolverTest {
    private static final String GROUP_1 = "group1";
    private static final String GROUP_2 = "group2";
    private static final Username USER_1 = Username.of((String)"user1");
    private static final Username USER_2 = Username.of((String)"user2");
    private MailboxACL anybodyRead;
    private MailboxACL anybodyReadNegative;
    private UnionMailboxACLResolver anyoneReadListGlobal;
    private MailboxACL authenticatedRead;
    private UnionMailboxACLResolver authenticatedReadListWriteGlobal;
    private MailboxACL authenticatedReadNegative;
    private MailboxACL group1Read;
    private MailboxACL group1ReadNegative;
    private SimpleGroupMembershipResolver groupMembershipResolver;
    private UnionMailboxACLResolver negativeGroup2FullGlobal;
    private UnionMailboxACLResolver noGlobals;
    private UnionMailboxACLResolver ownerFullGlobal;
    private MailboxACL ownerRead;
    private MailboxACL ownerReadNegative;
    private MailboxACL user1Read;
    private MailboxACL user1ReadNegative;
    private MailboxACL.EntryKey user1Key;
    private MailboxACL.EntryKey user2Key;
    private MailboxACL.EntryKey group1Key;
    private MailboxACL.EntryKey group2Key;

    UnionMailboxACLResolverTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.user1Key = MailboxACL.EntryKey.createUserEntryKey((Username)USER_1);
        this.user2Key = MailboxACL.EntryKey.createUserEntryKey((Username)USER_2);
        this.group1Key = MailboxACL.EntryKey.createGroupEntryKey((String)GROUP_1);
        this.group2Key = MailboxACL.EntryKey.createGroupEntryKey((String)GROUP_2);
        MailboxACL acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_KEY, MailboxACL.FULL_RIGHTS)});
        this.authenticatedReadListWriteGlobal = new UnionMailboxACLResolver(acl, acl);
        acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"rl"))});
        this.anyoneReadListGlobal = new UnionMailboxACLResolver(acl, acl);
        acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_KEY, MailboxACL.FULL_RIGHTS)});
        this.ownerFullGlobal = new UnionMailboxACLResolver(acl, acl);
        this.noGlobals = new UnionMailboxACLResolver(MailboxACL.EMPTY, MailboxACL.EMPTY);
        acl = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(new MailboxACL.EntryKey(GROUP_2, MailboxACL.NameType.group, true), MailboxACL.FULL_RIGHTS)});
        this.negativeGroup2FullGlobal = new UnionMailboxACLResolver(acl, new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(new MailboxACL.EntryKey(GROUP_2, MailboxACL.NameType.group, true), MailboxACL.FULL_RIGHTS)}));
        this.groupMembershipResolver = new SimpleGroupMembershipResolver();
        this.groupMembershipResolver.addMembership(GROUP_1, USER_1);
        this.groupMembershipResolver.addMembership(GROUP_2, USER_2);
        this.user1Read = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(this.user1Key, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.user1ReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.EntryKey.createUserEntryKey((Username)USER_1, (boolean)true), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.group1Read = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(this.group1Key, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.group1ReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.EntryKey.createGroupEntryKey((String)GROUP_1, (boolean)true), MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.anybodyRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.anybodyReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.ANYBODY_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.authenticatedRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.authenticatedReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.AUTHENTICATED_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.ownerRead = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
        this.ownerReadNegative = new MailboxACL(new Map.Entry[]{new MailboxACL.Entry(MailboxACL.OWNER_NEGATIVE_KEY, MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"r"))});
    }

    @Test
    void testAppliesNullUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, null, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
    }

    @Test
    void testAppliesUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_2.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_1, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)this.user1Key, (GroupMembershipResolver)this.groupMembershipResolver, (String)GROUP_2, (boolean)true)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user1Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.user2Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group1Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)this.group2Key, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isFalse();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.ANYBODY_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.AUTHENTICATED_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
        Assertions.assertThat((boolean)UnionMailboxACLResolver.applies((MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (MailboxACL.EntryKey)MailboxACL.OWNER_KEY, (GroupMembershipResolver)this.groupMembershipResolver, (String)USER_1.asString(), (boolean)false)).isTrue();
    }

    @Test
    void testResolveRightsNullUser() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsNullUserGlobals() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, MailboxACL.EMPTY, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, MailboxACL.EMPTY, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, MailboxACL.EMPTY, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(null, (GroupMembershipResolver)this.groupMembershipResolver, MailboxACL.EMPTY, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserSelfOwner() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_1.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserNotOwner() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, USER_2.asString(), false).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserMemberOfOwnerGroup() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_1, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_1, true).contains(MailboxACL.Right.Read)).isFalse();
    }

    @Test
    void testResolveRightsUserNotMemberOfOwnerGroup() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.user1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1Read, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.group1ReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.anybodyReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.authenticatedReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.anyoneReadListGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.authenticatedReadListWriteGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isTrue();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.ownerFullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.noGlobals.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerRead, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
        Assertions.assertThat((boolean)this.negativeGroup2FullGlobal.resolveRights(USER_1, (GroupMembershipResolver)this.groupMembershipResolver, this.ownerReadNegative, GROUP_2, true).contains(MailboxACL.Right.Read)).isFalse();
    }
}

