/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.events;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.events.MailboxIdRegistrationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.TestId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxIdRegistrationKeyTest {
    private static final String ID = "42";
    private static final MailboxIdRegistrationKey.Factory FACTORY = new MailboxIdRegistrationKey.Factory((MailboxId.Factory)new TestId.Factory());
    private static final MailboxIdRegistrationKey MAILBOX_ID_REGISTRATION_KEY = new MailboxIdRegistrationKey((MailboxId)TestId.of(42L));

    MailboxIdRegistrationKeyTest() {
    }

    @Test
    void shouldRespectBeanContract() {
        EqualsVerifier.forClass(MailboxIdRegistrationKey.class).verify();
    }

    @Test
    void asStringShouldReturnSerializedMailboxId() {
        Assertions.assertThat((String)MAILBOX_ID_REGISTRATION_KEY.asString()).isEqualTo(ID);
    }

    @Test
    void fromStringShouldReturnCorrespondingRegistrationKey() {
        Assertions.assertThat((Object)FACTORY.fromString(ID)).isEqualTo((Object)MAILBOX_ID_REGISTRATION_KEY);
    }

    @Test
    void fromStringShouldThrowOnInvalidValues() {
        Assertions.assertThatThrownBy(() -> FACTORY.fromString("invalid")).isInstanceOf(IllegalArgumentException.class);
    }
}

