/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.UUID;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.BlobId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AttachmentIdTest {
    AttachmentIdTest() {
    }

    @Test
    void randomShouldGenerateDifferentIds() {
        AttachmentId attachmentId = AttachmentId.random();
        AttachmentId attachmentId2 = AttachmentId.random();
        Assertions.assertThat((String)attachmentId.getId()).isNotEqualTo((Object)attachmentId2.getId());
    }

    @Test
    void fromShouldThrowWhenIdIsNull() {
        String value = null;
        Assertions.assertThatThrownBy(() -> AttachmentId.from((String)value)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldThrowWhenBlobIdIsNull() {
        BlobId value = null;
        Assertions.assertThatThrownBy(() -> AttachmentId.from((BlobId)value)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldThrowWhenIdIsEmpty() {
        Assertions.assertThatThrownBy(() -> AttachmentId.from((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromStringShouldWork() {
        String expectedId = "f07e5a815613c5abeddc4b682247a4c42d8a95df";
        AttachmentId attachmentId = AttachmentId.from((String)expectedId);
        Assertions.assertThat((String)attachmentId.getId()).isEqualTo(expectedId);
    }

    @Test
    void fromBlobIdShouldWork() {
        String expectedId = "f07e5a815613c5abeddc4b682247a4c42d8a95df";
        AttachmentId attachmentId = AttachmentId.from((BlobId)BlobId.fromString((String)expectedId));
        Assertions.assertThat((String)attachmentId.getId()).isEqualTo(expectedId);
    }

    @Test
    void asUUIDShouldReturnAValidUUID() {
        AttachmentId attachmentId = AttachmentId.from((String)"magic");
        Assertions.assertThat((Comparable)attachmentId.asUUID()).isEqualTo((Object)UUID.fromString("2f3a4fcc-ca64-36e3-9bcf-33e92dd93135"));
    }
}

