/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AttachmentMetadataTest {
    AttachmentMetadataTest() {
    }

    @Test
    void builderShouldThrowWhenAttachmentIdIsNull() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().attachmentId(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void builderShouldThrowWhenTypeIsNull() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().type((String)null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void builderShouldThrowWhenTypeIsEmpty() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().type("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void buildShouldThrowWhenAttachmentIdIsNotProvided() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowWhenSizeIsNotProvided() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().attachmentId(AttachmentId.random()).type("TYPE").build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowWhenTypeIsNotProvided() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().attachmentId(AttachmentId.random()).size(36L).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void sizeShouldThrowOnNegativeValue() {
        Assertions.assertThatThrownBy(() -> AttachmentMetadata.builder().attachmentId(AttachmentId.random()).size(-3L)).isInstanceOf(IllegalArgumentException.class);
    }
}

