/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.nio.charset.StandardCharsets;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.BlobId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobIdTest {
    BlobIdTest() {
    }

    @Test
    void shouldMatchBeanContact() {
        EqualsVerifier.forClass(BlobId.class).verify();
    }

    @Test
    void fromStringShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> BlobId.fromString(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void fromStringShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> BlobId.fromString((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void asStringShouldReturnUnderlyingId() {
        Assertions.assertThat((String)BlobId.fromString((String)"abc").asString()).isEqualTo("abc");
    }

    @Test
    void fromBytesShouldProduceASHA256() {
        Assertions.assertThat((String)BlobId.fromBytes((byte[])"abc".getBytes(StandardCharsets.UTF_8)).asString()).isEqualTo("ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad");
    }

    @Test
    void fromBytesShouldCalculateSameSha256() {
        byte[] bytes = "abc".getBytes(StandardCharsets.UTF_8);
        Assertions.assertThat((Object)BlobId.fromBytes((byte[])bytes)).isEqualTo((Object)BlobId.fromBytes((byte[])bytes));
    }
}

