/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.Blob;
import org.apache.james.mailbox.model.BlobId;
import org.apache.james.mailbox.model.ContentType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class BlobTest {
    static final BlobId ID = BlobId.fromString((String)"123");
    static final ContentType CONTENT_TYPE = ContentType.of((String)"text/plain");
    static final Blob.InputStreamSupplier PAYLOAD = () -> new ByteArrayInputStream("abc".getBytes(StandardCharsets.UTF_8));
    static final int LENGTH = 3;

    BlobTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(Blob.class).withIgnoredFields(new String[]{"payload", "size"}).verify();
    }

    @Test
    void buildShouldConstructValidBlob() {
        Assertions.assertThat((Object)Blob.builder().id(ID).contentType(CONTENT_TYPE).payload(PAYLOAD).size(3L).build()).isEqualTo((Object)new Blob(ID, PAYLOAD, CONTENT_TYPE, 3L));
    }

    @Test
    void buildShouldThrowOnMissingBlobId() {
        Assertions.assertThatThrownBy(() -> Blob.builder().contentType(CONTENT_TYPE).payload(PAYLOAD).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowOnMissingContentType() {
        Assertions.assertThatThrownBy(() -> Blob.builder().id(ID).payload(PAYLOAD).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowOnMissingPayload() {
        Assertions.assertThatThrownBy(() -> Blob.builder().id(ID).contentType(CONTENT_TYPE).build()).isInstanceOf(IllegalStateException.class);
    }
}

