/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.nio.charset.StandardCharsets;
import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.ContentType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContentTypeTest {
    ContentTypeTest() {
    }

    @Test
    void contentTypeShouldRespectBeanContract() {
        EqualsVerifier.forClass(ContentType.class).verify();
    }

    @Test
    void subTypeShouldRespectBeanContract() {
        EqualsVerifier.forClass(ContentType.SubType.class).verify();
    }

    @Test
    void mediaTypeShouldRespectBeanContract() {
        EqualsVerifier.forClass(ContentType.MediaType.class).verify();
    }

    @Test
    void mimeTypeShouldRespectBeanContract() {
        EqualsVerifier.forClass(ContentType.MimeType.class).verify();
    }

    @Test
    void mimeTypeOfShouldThrowWhenInvalid() {
        Assertions.assertThatThrownBy(() -> ContentType.MimeType.of((String)"aaa")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void mimeTypeOfShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> ContentType.of((String)"")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void mimeTypeOfShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> ContentType.of((String)null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void mimeTypeOfShouldReturnExpectedValue() {
        Assertions.assertThat((Object)ContentType.MimeType.of((String)"text/html")).isEqualTo((Object)ContentType.MimeType.of((ContentType.MediaType)ContentType.MediaType.of((String)"text"), (ContentType.SubType)ContentType.SubType.of((String)"html")));
    }

    @Test
    void mediaTypeOfShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> ContentType.MediaType.of((String)"")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void subTypeOfShouldThrowWhenEmpty() {
        Assertions.assertThatThrownBy(() -> ContentType.SubType.of((String)"")).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void asMime4JShouldNotThrowWhenInvalidContentType() {
        ContentType invalid = ContentType.of((String)"/invalid");
        Assertions.assertThatCode(() -> ((ContentType)invalid).asMime4J()).doesNotThrowAnyException();
    }

    @Test
    void mimeTypeShouldThrowWhenInvalidContentType() {
        ContentType invalid = ContentType.of((String)"invalid");
        Assertions.assertThatThrownBy(() -> ((ContentType)invalid).mimeType()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void mediaTypeShouldThrowWhenInvalidContentType() {
        ContentType invalid = ContentType.of((String)"invalid");
        Assertions.assertThatThrownBy(() -> ((ContentType)invalid).mediaType()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void subTypeShouldThrowWhenInvalidContentType() {
        ContentType invalid = ContentType.of((String)"invalid");
        Assertions.assertThatThrownBy(() -> ((ContentType)invalid).subType()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void charsetShouldThrowWhenInvalidCharset() {
        ContentType invalid = ContentType.of((String)"text/plain; charset=invalid");
        Assertions.assertThatThrownBy(() -> ((ContentType)invalid).charset()).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void charsetShouldThrowWhenEmptyCharset() {
        ContentType contentType = ContentType.of((String)"text/plain; charset=");
        Assertions.assertThat((Optional)contentType.charset()).isEmpty();
    }

    @Test
    void asStringShouldReturnWhenInvalid() {
        String value = "invalid";
        ContentType invalid = ContentType.of((String)value);
        Assertions.assertThat((String)invalid.asString()).isEqualTo(value);
    }

    @Test
    void charsetShouldReturnEmptyWhenNone() {
        ContentType contentType = ContentType.of((String)"text/html");
        Assertions.assertThat((Optional)contentType.charset()).isEmpty();
    }

    @Test
    void charsetShouldReturnSuppliedCharset() {
        ContentType contentType = ContentType.of((String)"text/html; charset=UTF-8");
        Assertions.assertThat((Optional)contentType.charset()).contains((Object)StandardCharsets.UTF_8);
    }

    @Test
    void mimeTypeShouldReturnSuppliedValue() {
        ContentType contentType = ContentType.of((String)"text/html");
        Assertions.assertThat((Object)contentType.mimeType()).isEqualTo((Object)ContentType.MimeType.of((String)"text/html"));
    }

    @Test
    void subTypeShouldReturnSuppliedValue() {
        ContentType contentType = ContentType.of((String)"text/html");
        Assertions.assertThat((Object)contentType.subType()).isEqualTo((Object)ContentType.SubType.of((String)"html"));
    }

    @Test
    void mediaTypeShouldReturnSuppliedValue() {
        ContentType contentType = ContentType.of((String)"text/html");
        Assertions.assertThat((Object)contentType.mediaType()).isEqualTo((Object)ContentType.MediaType.of((String)"text"));
    }
}

