/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.stream.Stream;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.mailbox.model.FetchGroup;
import org.apache.james.mailbox.model.MimePath;
import org.apache.james.mailbox.model.PartContentDescriptor;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class FetchGroupTest {
    FetchGroupTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(FetchGroup.class).withNonnullFields(new String[]{"profiles"}).verify();
    }

    static Stream<Arguments> withShouldAddNewValuesInSet() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{EnumSet.noneOf(FetchGroup.Profile.class), EnumSet.noneOf(FetchGroup.Profile.class), EnumSet.noneOf(FetchGroup.Profile.class)}), Arguments.arguments((Object[])new Object[]{EnumSet.noneOf(FetchGroup.Profile.class), EnumSet.allOf(FetchGroup.Profile.class), EnumSet.allOf(FetchGroup.Profile.class)}), Arguments.arguments((Object[])new Object[]{EnumSet.allOf(FetchGroup.Profile.class), EnumSet.noneOf(FetchGroup.Profile.class), EnumSet.allOf(FetchGroup.Profile.class)}), Arguments.arguments((Object[])new Object[]{EnumSet.noneOf(FetchGroup.Profile.class), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT)}), Arguments.arguments((Object[])new Object[]{EnumSet.of(FetchGroup.Profile.BODY_CONTENT), EnumSet.of(FetchGroup.Profile.FULL_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT)}), Arguments.arguments((Object[])new Object[]{EnumSet.of(FetchGroup.Profile.BODY_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT)}), Arguments.arguments((Object[])new Object[]{EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT)}), Arguments.arguments((Object[])new Object[]{EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT), EnumSet.of(FetchGroup.Profile.BODY_CONTENT, FetchGroup.Profile.FULL_CONTENT)}));
    }

    @ParameterizedTest
    @MethodSource
    void withShouldAddNewValuesInSet(EnumSet<FetchGroup.Profile> initial, EnumSet<FetchGroup.Profile> addition, EnumSet<FetchGroup.Profile> expected) {
        FetchGroup fetchGroup = new FetchGroup(initial);
        Assertions.assertThat((Iterable)((FetchGroup)fetchGroup.with(addition)).profiles()).isEqualTo(expected);
    }

    @Test
    void addPartContentShouldAddPartContentWhenNotYetSpecified() {
        int[] path = new int[]{12};
        Assertions.assertThat((Object)FetchGroup.MINIMAL.addPartContent(new MimePath(path), EnumSet.noneOf(FetchGroup.Profile.class))).isEqualTo((Object)new FetchGroup(EnumSet.noneOf(FetchGroup.Profile.class), ImmutableSet.of((Object)new PartContentDescriptor(new MimePath(path)))));
    }

    @Test
    void addPartContentShouldUnionDifferentPartContents() {
        int[] path = new int[]{12};
        int[] path2 = new int[]{13};
        Assertions.assertThat((Object)FetchGroup.MINIMAL.addPartContent(new MimePath(path), EnumSet.noneOf(FetchGroup.Profile.class)).addPartContent(new MimePath(path2), EnumSet.noneOf(FetchGroup.Profile.class))).isEqualTo((Object)new FetchGroup(EnumSet.noneOf(FetchGroup.Profile.class), ImmutableSet.of((Object)new PartContentDescriptor(new MimePath(path)), (Object)new PartContentDescriptor(new MimePath(path2)))));
    }

    @Test
    void addPartContentShouldModifyPartContentWhenAlreadySpecified() {
        int[] path = new int[]{12};
        Assertions.assertThat((Object)FetchGroup.MINIMAL.addPartContent(new MimePath(path), EnumSet.noneOf(FetchGroup.Profile.class)).addPartContent(new MimePath(path), new FetchGroup.Profile[]{FetchGroup.Profile.HEADERS})).isEqualTo((Object)new FetchGroup(EnumSet.noneOf(FetchGroup.Profile.class), ImmutableSet.of((Object)new PartContentDescriptor(EnumSet.of(FetchGroup.Profile.HEADERS), new MimePath(path)))));
    }
}

