/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.james.mailbox.model.Mailbox;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ProxyableObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;

public class MailboxAssertingTool {
    public static MailboxAssert assertThat(Mailbox actual) {
        return new MailboxAssert(actual);
    }

    public static MailboxSoftlyAssert.RequireActualMailbox softly(SoftAssertions softly) {
        return actual -> new MailboxSoftlyAssert.MailboxAssertingStage(softly, actual);
    }

    private static String mailboxIdFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected MailboxId to be <%s> but was <%s>", expected.getMailboxId(), actual.getMailboxId());
    }

    private static String namespaceFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected NameSpace to be <%s> but was <%s>", expected.getNamespace(), actual.getNamespace());
    }

    private static String userFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected User to be <%s> but was <%s>", expected.getUser(), actual.getUser());
    }

    private static String nameFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected Name to be <%s> but was <%s>", expected.getName(), actual.getName());
    }

    private static String aclFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected ACL to be <%s> but was <%s>", expected.getACL(), actual.getACL());
    }

    private static String uidValidityFailMessage(Mailbox expected, Mailbox actual) {
        return String.format("Expected UID Validity to be <%s> but was <%s>", expected.getUidValidity(), actual.getUidValidity());
    }

    public static class MailboxSoftlyAssert {

        public static class MailboxAssertingStage {
            private final SoftAssertions softly;
            private final Mailbox actual;

            MailboxAssertingStage(SoftAssertions softly, Mailbox actual) {
                Preconditions.checkNotNull((Object)softly);
                Preconditions.checkNotNull((Object)actual);
                this.softly = softly;
                this.actual = actual;
            }

            public void isEqualTo(Mailbox expected) {
                Preconditions.checkNotNull((Object)expected);
                ((ProxyableObjectAssert)this.softly.assertThat((Object)this.actual.getMailboxId()).withFailMessage(MailboxAssertingTool.mailboxIdFailMessage(expected, this.actual), new Object[0])).isEqualTo((Object)expected.getMailboxId());
                ((StringAssert)this.softly.assertThat(this.actual.getName()).withFailMessage(MailboxAssertingTool.nameFailMessage(expected, this.actual), new Object[0])).isEqualTo(expected.getName());
                ((ProxyableObjectAssert)this.softly.assertThat((Object)this.actual.getUidValidity()).withFailMessage(MailboxAssertingTool.uidValidityFailMessage(expected, this.actual), new Object[0])).isEqualTo((Object)expected.getUidValidity());
                ((ProxyableObjectAssert)this.softly.assertThat((Object)this.actual.getUser()).withFailMessage(MailboxAssertingTool.userFailMessage(expected, this.actual), new Object[0])).isEqualTo((Object)expected.getUser());
                ((StringAssert)this.softly.assertThat(this.actual.getNamespace()).withFailMessage(MailboxAssertingTool.namespaceFailMessage(expected, this.actual), new Object[0])).isEqualTo(expected.getNamespace());
                ((ProxyableObjectAssert)this.softly.assertThat((Object)this.actual.getACL()).withFailMessage(MailboxAssertingTool.aclFailMessage(expected, this.actual), new Object[0])).isEqualTo((Object)expected.getACL());
            }
        }

        @FunctionalInterface
        public static interface RequireActualMailbox {
            public MailboxAssertingStage assertThat(Mailbox var1);
        }
    }

    public static class MailboxAssert
    extends AbstractAssert<MailboxAssert, Mailbox> {
        private MailboxAssert(Mailbox actual) {
            super((Object)actual, MailboxAssert.class);
        }

        public MailboxAssert isEqualTo(Mailbox expected) {
            this.isNotNull();
            if (!Objects.equals(((Mailbox)this.actual).getMailboxId(), expected.getMailboxId())) {
                this.failWithMessage(MailboxAssertingTool.mailboxIdFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            if (!Objects.equals(((Mailbox)this.actual).getNamespace(), expected.getNamespace())) {
                this.failWithMessage(MailboxAssertingTool.namespaceFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            if (!Objects.equals(((Mailbox)this.actual).getUser(), expected.getUser())) {
                this.failWithMessage(MailboxAssertingTool.userFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            if (!Objects.equals(((Mailbox)this.actual).getName(), expected.getName())) {
                this.failWithMessage(MailboxAssertingTool.nameFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            if (!Objects.equals(((Mailbox)this.actual).getACL(), expected.getACL())) {
                this.failWithMessage(MailboxAssertingTool.aclFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            if (!Objects.equals(((Mailbox)this.actual).getUidValidity(), expected.getUidValidity())) {
                this.failWithMessage(MailboxAssertingTool.uidValidityFailMessage(expected, (Mailbox)this.actual), new Object[0]);
            }
            return this;
        }
    }
}

