/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Strings;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Username;
import org.apache.james.mailbox.exception.HasEmptyMailboxNameInHierarchyException;
import org.apache.james.mailbox.exception.MailboxNameException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailboxPathTest {
    private static final Username USER = Username.of((String)"user");

    MailboxPathTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(MailboxPath.class).verify();
    }

    @Test
    void asStringShouldFormatUser() {
        Assertions.assertThat((String)MailboxPath.forUser((Username)USER, (String)"inbox.folder.subfolder").asString()).isEqualTo("#private:user:inbox.folder.subfolder");
    }

    @Test
    void getNameShouldReturnSubfolder() {
        Assertions.assertThat((String)MailboxPath.forUser((Username)USER, (String)"inbox.folder.subfolder").getName('.')).isEqualTo("subfolder");
    }

    @Test
    void getNameShouldNoopWhenNoDelimiter() {
        Assertions.assertThat((String)MailboxPath.forUser((Username)USER, (String)"name").getName('.')).isEqualTo("name");
    }

    @Test
    void getNameShouldNoopWhenEmpty() {
        Assertions.assertThat((String)MailboxPath.forUser((Username)USER, (String)"").getName('.')).isEqualTo("");
    }

    @Test
    void getNameShouldNoopWhenBlank() {
        Assertions.assertThat((String)MailboxPath.forUser((Username)USER, (String)"  ").getName('.')).isEqualTo("  ");
    }

    @Test
    void getHierarchyLevelsShouldBeOrdered() {
        Assertions.assertThat((List)MailboxPath.forUser((Username)USER, (String)"inbox.folder.subfolder").getHierarchyLevels('.')).containsExactly((Object[])new MailboxPath[]{MailboxPath.forUser((Username)USER, (String)"inbox"), MailboxPath.forUser((Username)USER, (String)"inbox.folder"), MailboxPath.forUser((Username)USER, (String)"inbox.folder.subfolder")});
    }

    @Test
    void childShouldConcatenateChildNameWithParentForlder() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)"folder").child("toto", '.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)"folder.toto"));
    }

    @Test
    void childShouldThrowWhenNull() {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"folder");
        Assertions.assertThatThrownBy(() -> path.child(null, '.')).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void childShouldThrowWhenEmpty() {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"folder");
        Assertions.assertThatThrownBy(() -> path.child("", '.')).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void childShouldThrowWhenBlank() {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"folder");
        Assertions.assertThatThrownBy(() -> path.child(" ", '.')).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void childShouldThrowWhenContainsDelimiter() {
        MailboxPath path = MailboxPath.forUser((Username)USER, (String)"folder");
        Assertions.assertThatThrownBy(() -> path.child("a.b", '.')).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void getHierarchyLevelsShouldReturnPathWhenOneLevel() {
        Assertions.assertThat((List)MailboxPath.forUser((Username)USER, (String)"inbox").getHierarchyLevels('.')).containsExactly((Object[])new MailboxPath[]{MailboxPath.forUser((Username)USER, (String)"inbox")});
    }

    @Test
    void getHierarchyLevelsShouldReturnPathWhenEmptyName() {
        Assertions.assertThat((List)MailboxPath.forUser((Username)USER, (String)"").getHierarchyLevels('.')).containsExactly((Object[])new MailboxPath[]{MailboxPath.forUser((Username)USER, (String)"")});
    }

    @Test
    void getHierarchyLevelsShouldReturnPathWhenBlankName() {
        Assertions.assertThat((List)MailboxPath.forUser((Username)USER, (String)"  ").getHierarchyLevels('.')).containsExactly((Object[])new MailboxPath[]{MailboxPath.forUser((Username)USER, (String)"  ")});
    }

    @Test
    void getHierarchyLevelsShouldReturnPathWhenNullName() {
        Assertions.assertThat((List)MailboxPath.forUser((Username)USER, null).getHierarchyLevels('.')).containsExactly((Object[])new MailboxPath[]{MailboxPath.forUser((Username)USER, null)});
    }

    @Test
    void sanitizeShouldNotThrowOnNullMailboxName() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, null).sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, null));
    }

    @Test
    void sanitizeShouldReturnEmptyWhenEmpty() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)"").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)""));
    }

    @Test
    void sanitizeShouldRemoveMaximumOneTrailingDelimiterWhenAlone() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)".").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)""));
    }

    @Test
    void sanitizeShouldPreserveHeadingDelimiter() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)".a").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)".a"));
    }

    @Test
    void sanitizeShouldRemoveTrailingDelimiter() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)"a.").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)"a"));
    }

    @Test
    void sanitizeShouldRemoveMaximumOneTrailingDelimiter() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)"a..").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)"a."));
    }

    @Test
    void sanitizeShouldPreserveRedundantDelimiters() {
        Assertions.assertThat((Object)MailboxPath.forUser((Username)USER, (String)"a..a").sanitize('.')).isEqualTo((Object)MailboxPath.forUser((Username)USER, (String)"a..a"));
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeFalseIfSingleLevelPath() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a").hasEmptyNameInHierarchy('.')).isFalse();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeFalseIfNestedLevelWithNonEmptyNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a.b.c").hasEmptyNameInHierarchy('.')).isFalse();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfEmptyPath() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfBlankPath() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)" ").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithTwoEmptyNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)".").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithAnEmptyNameBetweenTwoNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a..b").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithABlankNameBetweenTwoNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a.   .b").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithHeadingEmptyNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"..a").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithHeadingBlankName() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"  .a").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithATrailingEmptyName() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a.").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithATrailingBlankName() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a.  ").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithTrailingEmptyNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a..").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void hasEmptyNameInHierarchyShouldBeTrueIfPathWithTrailingBlankNames() {
        Assertions.assertThat((boolean)MailboxPath.forUser((Username)USER, (String)"a. .  ").hasEmptyNameInHierarchy('.')).isTrue();
    }

    @Test
    void assertAcceptableShouldThrowOnDoubleSeparator() {
        Assertions.assertThatThrownBy(() -> MailboxPath.forUser((Username)USER, (String)"a..b").assertAcceptable('.')).isInstanceOf(HasEmptyMailboxNameInHierarchyException.class);
    }

    @Test
    void assertAcceptableShouldThrowWhenStartsWithSharp() {
        Assertions.assertThatThrownBy(() -> MailboxPath.forUser((Username)USER, (String)"#ab").assertAcceptable('.')).isInstanceOf(MailboxNameException.class);
    }

    @Test
    void assertAcceptableShouldNotThrowWhenSharpInTheMiddle() {
        Assertions.assertThatCode(() -> MailboxPath.forUser((Username)USER, (String)"mailbox #17").assertAcceptable('.')).doesNotThrowAnyException();
    }

    @Test
    void assertAcceptableShouldThrowOnPercent() {
        Assertions.assertThatThrownBy(() -> MailboxPath.forUser((Username)USER, (String)"a%b").assertAcceptable('.')).isInstanceOf(MailboxNameException.class);
    }

    @Test
    void assertAcceptableShouldThrowOnWildcard() {
        Assertions.assertThatThrownBy(() -> MailboxPath.forUser((Username)USER, (String)"a*b").assertAcceptable('.')).isInstanceOf(MailboxNameException.class);
    }

    @Test
    void assertAcceptableShouldThrowOnTooLongMailboxName() {
        Assertions.assertThatThrownBy(() -> MailboxPath.forUser((Username)USER, (String)Strings.repeat((String)"a", (int)201)).assertAcceptable('.')).isInstanceOf(TooLongMailboxNameException.class);
    }

    @Test
    void assertAcceptableShouldNotThrowOnNotTooLongMailboxName() {
        Assertions.assertThatCode(() -> MailboxPath.forUser((Username)USER, (String)Strings.repeat((String)"a", (int)200)).assertAcceptable('.')).doesNotThrowAnyException();
    }

    @Test
    void isInboxShouldReturnTrueWhenINBOX() {
        MailboxPath mailboxPath = new MailboxPath("#private", USER, "INBOX");
        Assertions.assertThat((boolean)mailboxPath.isInbox()).isTrue();
    }

    @Test
    void isInboxShouldReturnTrueWhenINBOXWithOtherCase() {
        MailboxPath mailboxPath = new MailboxPath("#private", USER, "InBoX");
        Assertions.assertThat((boolean)mailboxPath.isInbox()).isTrue();
    }

    @Test
    void isInboxShouldReturnFalseWhenOtherThanInbox() {
        MailboxPath mailboxPath = new MailboxPath("#private", USER, "Archive");
        Assertions.assertThat((boolean)mailboxPath.isInbox()).isFalse();
    }
}

