/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Optional;
import org.apache.james.mailbox.model.AttachmentId;
import org.apache.james.mailbox.model.AttachmentMetadata;
import org.apache.james.mailbox.model.Cid;
import org.apache.james.mailbox.model.MessageAttachmentMetadata;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MessageAttachmentMetadataTest {
    MessageAttachmentMetadataTest() {
    }

    @Test
    void buildShouldThrowWhenAttachmentIsNotGiven() {
        Assertions.assertThatThrownBy(() -> MessageAttachmentMetadata.builder().build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void builderShouldThrowWhenAttachmentIsNull() {
        Assertions.assertThatThrownBy(() -> MessageAttachmentMetadata.builder().attachment(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void buildShouldWorkWhenMandatoryAttributesAreGiven() {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata expectedMessageAttachment = new MessageAttachmentMetadata(attachment, Optional.empty(), Optional.empty(), false);
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).build();
        Assertions.assertThat((Object)messageAttachment).isEqualTo((Object)expectedMessageAttachment);
    }

    @Test
    void buildShouldAcceptIsInlineAndNoCid() {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).isInline(Boolean.valueOf(true)).build();
        Assertions.assertThat((boolean)messageAttachment.isInline()).isTrue();
    }

    @Test
    void buildShouldSetAttributesWhenAllAreGiven() {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata expectedMessageAttachment = new MessageAttachmentMetadata(attachment, Optional.of("name"), Optional.of(Cid.from((String)"cid")), true);
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).name("name").cid(Cid.from((String)"cid")).isInline(Boolean.valueOf(true)).build();
        Assertions.assertThat((Object)messageAttachment).isEqualTo((Object)expectedMessageAttachment);
    }

    @Test
    void isInlinedWithCidShouldReturnTrueWhenIsInlineAndHasCid() throws Exception {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).name("name").cid(Cid.from((String)"cid")).isInline(Boolean.valueOf(true)).build();
        Assertions.assertThat((boolean)messageAttachment.isInlinedWithCid()).isTrue();
    }

    @Test
    void isInlinedWithCidShouldReturnFalseWhenIsNotInline() throws Exception {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).name("name").cid(Cid.from((String)"cid")).isInline(Boolean.valueOf(false)).build();
        Assertions.assertThat((boolean)messageAttachment.isInlinedWithCid()).isFalse();
    }

    @Test
    void isInlinedWithCidShouldReturnFalseWhenIsInlineButNoCid() throws Exception {
        AttachmentMetadata attachment = AttachmentMetadata.builder().attachmentId(AttachmentId.from((String)"1")).size(36L).type("type").build();
        MessageAttachmentMetadata messageAttachment = MessageAttachmentMetadata.builder().attachment(attachment).name("name").isInline(Boolean.valueOf(true)).build();
        Assertions.assertThat((boolean)messageAttachment.isInlinedWithCid()).isFalse();
    }
}

