/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.core.Domain;
import org.apache.james.mailbox.model.QuotaRoot;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaRootTest {
    QuotaRootTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(QuotaRoot.class).verify();
    }

    @Test
    void asStringShouldReturnValueWhenNoDomain() {
        String value = "#private&bob";
        QuotaRoot quotaRoot = QuotaRoot.quotaRoot((String)value, Optional.empty());
        Assertions.assertThat((String)quotaRoot.asString()).isEqualTo(value);
    }

    @Test
    void asStringShouldReturnValueWithDomainWhenHasDomain() {
        String value = "#private&bob";
        Domain domain = Domain.of((String)"apache.org");
        QuotaRoot quotaRoot = QuotaRoot.quotaRoot((String)value, Optional.of(domain));
        String expectedValue = "#private&bob@apache.org";
        Assertions.assertThat((String)quotaRoot.asString()).isEqualTo(expectedValue);
    }
}

