/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import org.apache.james.core.quota.QuotaCountLimit;
import org.apache.james.core.quota.QuotaCountUsage;
import org.apache.james.core.quota.QuotaLimitValue;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.core.quota.QuotaSizeUsage;
import org.apache.james.core.quota.QuotaUsageValue;
import org.apache.james.mailbox.model.Quota;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class QuotaTest {
    QuotaTest() {
    }

    @Test
    void isOverQuotaShouldReturnFalseWhenQuotaIsNotExceeded() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)36L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)360L)).build();
        Assertions.assertThat((boolean)quota.isOverQuota()).isFalse();
    }

    @Test
    void isOverQuotaShouldReturnFalseWhenMaxValueIsUnlimited() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)36L)).computedLimit((QuotaLimitValue)QuotaCountLimit.unlimited()).build();
        Assertions.assertThat((boolean)quota.isOverQuota()).isFalse();
    }

    @Test
    void isOverQuotaShouldReturnTrueWhenQuotaIsExceeded() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)360L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)36L)).build();
        Assertions.assertThat((boolean)quota.isOverQuota()).isTrue();
    }

    @Test
    void isOverQuotaWithAdditionalValueShouldReturnTrueWhenOverLimit() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)36L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)36L)).build();
        Assertions.assertThat((boolean)quota.isOverQuotaWithAdditionalValue(1L)).isTrue();
    }

    @Test
    void isOverQuotaWithAdditionalValueShouldReturnTrueWhenUnderLimit() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)34L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)36L)).build();
        Assertions.assertThat((boolean)quota.isOverQuotaWithAdditionalValue(1L)).isFalse();
    }

    @Test
    void isOverQuotaWithAdditionalValueShouldReturnFalseWhenAtLimit() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)36L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)36L)).build();
        Assertions.assertThat((boolean)quota.isOverQuotaWithAdditionalValue(0L)).isFalse();
    }

    @Test
    void isOverQuotaWithAdditionalValueShouldThrowOnNegativeValue() {
        Quota quota = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)25L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)36L)).build();
        Assertions.assertThatThrownBy(() -> quota.isOverQuotaWithAdditionalValue(-1L)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void buildShouldThrowOnMissingUsedValue() {
        Assertions.assertThatThrownBy(() -> Quota.builder().computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)1L)).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldThrowOnMissingComputedLimitValue() {
        Assertions.assertThatThrownBy(() -> Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)1L)).build()).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void buildShouldCreateValidObjectGivenMandatoryFields() {
        Quota actual = Quota.builder().used((QuotaUsageValue)QuotaCountUsage.count((long)1L)).computedLimit((QuotaLimitValue)QuotaCountLimit.count((long)2L)).build();
        Assertions.assertThat((Object)actual).isNotNull();
    }

    @Test
    void getRatioShouldReturnUsedDividedByLimit() {
        Assertions.assertThat((double)Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)15L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.size((long)60L)).build().getRatio()).isEqualTo(0.25);
    }

    @Test
    void getRatioShouldReturnZeroWhenUnlimited() {
        Assertions.assertThat((double)Quota.builder().used((QuotaUsageValue)QuotaSizeUsage.size((long)15L)).computedLimit((QuotaLimitValue)QuotaSizeLimit.unlimited()).build().getRatio()).isEqualTo(0.0);
    }
}

