/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import java.util.List;
import org.apache.james.mailbox.exception.UnsupportedRightException;
import org.apache.james.mailbox.model.MailboxACL;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class Rfc4314RightsTest {
    private MailboxACL.Rfc4314Rights aeik;
    private MailboxACL.Rfc4314Rights lprs;
    private MailboxACL.Rfc4314Rights twx;
    private MailboxACL.Rfc4314Rights full;
    private MailboxACL.Rfc4314Rights none;

    Rfc4314RightsTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.aeik = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"aeik");
        this.lprs = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"lprs");
        this.twx = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"twx");
        this.full = MailboxACL.FULL_RIGHTS;
        this.none = MailboxACL.NO_RIGHTS;
    }

    @Test
    void newInstanceShouldThrowWhenNullString() throws UnsupportedRightException {
        Assertions.assertThatThrownBy(() -> MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void newInstanceShouldHaveNoRightsWhenEmptyString() throws UnsupportedRightException {
        MailboxACL.Rfc4314Rights rights = MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"");
        Assertions.assertThat((List)rights.list()).isEmpty();
    }

    @Test
    void containsShouldReturnFalseWhenNotMatching() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.aeik.contains('x')).isFalse();
    }

    @Test
    void containsShouldReturnTrueWhenMatching() throws UnsupportedRightException {
        Assertions.assertThat((boolean)this.aeik.contains('e')).isTrue();
    }

    @Test
    void exceptShouldRemoveAllWhenChaining() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.full.except(this.aeik).except(this.lprs).except(this.twx)).isEqualTo((Object)this.none);
    }

    @Test
    void exceptShouldReturnOriginWhenExceptingNull() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.aeik.except(null)).isEqualTo((Object)this.aeik);
    }

    @Test
    void exceptShouldReturnOriginWhenExceptingNonExistent() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.aeik.except(this.lprs)).isEqualTo((Object)this.aeik);
    }

    @Test
    void rfc4314RightsShouldThrowWhenUnknownFlag() {
        Assertions.assertThatThrownBy(() -> MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"z")).isInstanceOf(UnsupportedRightException.class);
    }

    @Test
    void exceptShouldReturnOriginWhenExceptingEmpty() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.aeik.except(this.none)).isEqualTo((Object)this.aeik);
    }

    @Test
    void fullRightsShouldContainsAllRights() {
        Assertions.assertThat((List)this.full.list()).containsOnly((Object[])new MailboxACL.Right[]{MailboxACL.Right.Administer, MailboxACL.Right.PerformExpunge, MailboxACL.Right.Insert, MailboxACL.Right.CreateMailbox, MailboxACL.Right.Lookup, MailboxACL.Right.Post, MailboxACL.Right.Read, MailboxACL.Right.WriteSeenFlag, MailboxACL.Right.DeleteMessages, MailboxACL.Right.Write, MailboxACL.Right.DeleteMailbox});
    }

    @Test
    void noneRightsShouldContainsNoRights() {
        Assertions.assertThat((List)this.none.list()).isEmpty();
    }

    @Test
    void rightsShouldContainsSpecificRightsWhenAEIK() {
        Assertions.assertThat((List)this.aeik.list()).containsOnly((Object[])new MailboxACL.Right[]{MailboxACL.Right.Administer, MailboxACL.Right.PerformExpunge, MailboxACL.Right.Insert, MailboxACL.Right.CreateMailbox});
    }

    @Test
    void rightsShouldContainsSpecificRightsWhenLPRS() {
        Assertions.assertThat((List)this.lprs.list()).containsOnly((Object[])new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Post, MailboxACL.Right.Read, MailboxACL.Right.WriteSeenFlag});
    }

    @Test
    void rightsShouldContainsSpecificRightsWhenTWX() {
        Assertions.assertThat((List)this.twx.list()).containsOnly((Object[])new MailboxACL.Right[]{MailboxACL.Right.DeleteMessages, MailboxACL.Right.Write, MailboxACL.Right.DeleteMailbox});
    }

    @Test
    void getValueShouldReturnSigmaWhenAeik() {
        Assertions.assertThat((List)this.aeik.list()).containsExactly((Object[])new MailboxACL.Right[]{MailboxACL.Right.Administer, MailboxACL.Right.PerformExpunge, MailboxACL.Right.Insert, MailboxACL.Right.CreateMailbox});
    }

    @Test
    void getValueShouldReturnSigmaWhenLprs() {
        Assertions.assertThat((List)this.lprs.list()).containsExactly((Object[])new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Post, MailboxACL.Right.Read, MailboxACL.Right.WriteSeenFlag});
    }

    @Test
    void getValueShouldReturnSigmaWhenTwx() {
        Assertions.assertThat((List)this.twx.list()).containsExactly((Object[])new MailboxACL.Right[]{MailboxACL.Right.DeleteMessages, MailboxACL.Right.Write, MailboxACL.Right.DeleteMailbox});
    }

    @Test
    void getValueShouldReturnEmptyWhenNone() throws UnsupportedRightException {
        Assertions.assertThat((List)MailboxACL.Rfc4314Rights.fromSerializedRfc4314Rights((String)"").list()).isEmpty();
    }

    @Test
    void serializeShouldReturnStringWhenAeik() {
        Assertions.assertThat((String)this.aeik.serialize()).isEqualTo("aeik");
    }

    @Test
    void serializeShouldReturnStringWhenLprs() {
        Assertions.assertThat((String)this.lprs.serialize()).isEqualTo("lprs");
    }

    @Test
    void serializeShouldReturnStringWhenTwx() {
        Assertions.assertThat((String)this.twx.serialize()).isEqualTo("twx");
    }

    @Test
    void serializeShouldReturnStringWhenAeiklprstwx() {
        Assertions.assertThat((String)this.full.serialize()).isEqualTo("aeiklprstwx");
    }

    @Test
    void serializeShouldReturnEmptyStringWhenEmpty() {
        Assertions.assertThat((String)this.none.serialize()).isEmpty();
    }

    @Test
    void unionShouldReturnFullWhenChaining() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.aeik.union(this.lprs).union(this.twx)).isEqualTo((Object)this.full);
    }

    @Test
    void unionShouldReturnOriginWhenAppliedWithEmpty() throws UnsupportedRightException {
        Assertions.assertThat((Object)this.lprs.union(this.none)).isEqualTo((Object)this.lprs);
    }

    @Test
    void unionShouldThrowWhenAppliedWithNull() {
        Assertions.assertThatThrownBy(() -> this.lprs.union(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void containsShouldReturnFalseWhenRightNotPresent() {
        Assertions.assertThat((boolean)this.lprs.contains(MailboxACL.Right.Write)).isFalse();
    }

    @Test
    void containsShouldReturnFalseWhenAtLeastOneRightNotPresent() {
        Assertions.assertThat((boolean)this.lprs.contains(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Write})).isFalse();
    }

    @Test
    void containsShouldReturnTrueWhenAllRightsPresent() {
        Assertions.assertThat((boolean)this.lprs.contains(new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Post})).isTrue();
    }

    @Test
    void containsShouldReturnTrueWhenNonRightsPresent() {
        Assertions.assertThat((boolean)this.lprs.contains(new MailboxACL.Right[0])).isTrue();
    }

    @Test
    void allExceptShouldReturnFullWhenProvidedEmpty() throws UnsupportedRightException {
        Assertions.assertThat((Object)MailboxACL.Rfc4314Rights.allExcept((MailboxACL.Right[])new MailboxACL.Right[0])).isEqualTo((Object)MailboxACL.FULL_RIGHTS);
    }

    @Test
    void allExceptShouldReturnAllButProvidedRight() throws UnsupportedRightException {
        Assertions.assertThat((Object)MailboxACL.Rfc4314Rights.allExcept((MailboxACL.Right[])new MailboxACL.Right[]{MailboxACL.Right.Lookup})).isEqualTo((Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.DeleteMessages, MailboxACL.Right.Insert, MailboxACL.Right.Read, MailboxACL.Right.Administer, MailboxACL.Right.Write, MailboxACL.Right.WriteSeenFlag, MailboxACL.Right.PerformExpunge, MailboxACL.Right.CreateMailbox, MailboxACL.Right.Post, MailboxACL.Right.DeleteMailbox}));
    }

    @Test
    void allExceptShouldReturnAllButProvidedRights() throws UnsupportedRightException {
        Assertions.assertThat((Object)MailboxACL.Rfc4314Rights.allExcept((MailboxACL.Right[])new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read})).isEqualTo((Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[]{MailboxACL.Right.DeleteMessages, MailboxACL.Right.Insert, MailboxACL.Right.Administer, MailboxACL.Right.Write, MailboxACL.Right.WriteSeenFlag, MailboxACL.Right.PerformExpunge, MailboxACL.Right.CreateMailbox, MailboxACL.Right.Post, MailboxACL.Right.DeleteMailbox}));
    }

    @Test
    void allExceptShouldReturnEmptyWhenProvidedAllRights() throws UnsupportedRightException {
        Assertions.assertThat((Object)MailboxACL.Rfc4314Rights.allExcept((MailboxACL.Right[])new MailboxACL.Right[]{MailboxACL.Right.Lookup, MailboxACL.Right.Read, MailboxACL.Right.DeleteMessages, MailboxACL.Right.Insert, MailboxACL.Right.Administer, MailboxACL.Right.Write, MailboxACL.Right.WriteSeenFlag, MailboxACL.Right.PerformExpunge, MailboxACL.Right.CreateMailbox, MailboxACL.Right.Post, MailboxACL.Right.DeleteMailbox})).isEqualTo((Object)new MailboxACL.Rfc4314Rights(new MailboxACL.Right[0]));
    }
}

