/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.james.mailbox.model.MessageId;

public class TestMessageId
implements MessageId {
    private final long value;

    public static TestMessageId of(long value) {
        return new TestMessageId(value);
    }

    private TestMessageId(long value) {
        this.value = value;
    }

    public String serialize() {
        return String.valueOf(this.value);
    }

    public long getRawId() {
        return this.value;
    }

    public boolean isSerializable() {
        return true;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestMessageId) {
            TestMessageId other = (TestMessageId)obj;
            return Objects.equal((Object)this.value, (Object)other.value);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static class Factory
    implements MessageId.Factory {
        private AtomicLong counter = new AtomicLong();

        public MessageId fromString(String serialized) {
            return TestMessageId.of(Long.parseLong(serialized));
        }

        public MessageId generate() {
            return TestMessageId.of(this.counter.incrementAndGet());
        }
    }
}

