/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.dlp.eventsourcing.commands;

import java.util.List;
import org.apache.james.dlp.eventsourcing.aggregates.DLPAggregateId;
import org.apache.james.dlp.eventsourcing.aggregates.DLPDomainConfiguration;
import org.apache.james.dlp.eventsourcing.commands.StoreCommand;
import org.apache.james.eventsourcing.AggregateId;
import org.apache.james.eventsourcing.Event;
import org.apache.james.eventsourcing.eventstore.EventStore;
import org.apache.james.eventsourcing.javaapi.CommandHandlerJava;

public class StoreCommandHandler
implements CommandHandlerJava<StoreCommand> {
    private final EventStore eventStore;

    public StoreCommandHandler(EventStore eventStore) {
        this.eventStore = eventStore;
    }

    public Class<StoreCommand> handledClass() {
        return StoreCommand.class;
    }

    public List<? extends Event> handleJava(StoreCommand storeCommand) {
        DLPAggregateId aggregateId = new DLPAggregateId(storeCommand.getDomain());
        return DLPDomainConfiguration.load(aggregateId, this.eventStore.getEventsOfAggregate((AggregateId)aggregateId)).store(storeCommand.getRules());
    }
}

