/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.lib;

import java.util.EnumSet;
import java.util.List;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.Username;
import org.apache.james.rrt.api.AliasReverseResolver;
import org.apache.james.rrt.api.CanSendFrom;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.Mapping;
import org.apache.james.util.OptionalUtils;

public class CanSendFromImpl
implements CanSendFrom {
    public static final EnumSet<Mapping.Type> ALIAS_TYPES_ACCEPTED_IN_FROM = EnumSet.of(Mapping.Type.Alias, Mapping.Type.DomainAlias);
    private final RecipientRewriteTable recipientRewriteTable;
    private final AliasReverseResolver aliasReverseResolver;

    @Inject
    public CanSendFromImpl(RecipientRewriteTable recipientRewriteTable, AliasReverseResolver aliasReverseResolver) {
        this.recipientRewriteTable = recipientRewriteTable;
        this.aliasReverseResolver = aliasReverseResolver;
    }

    public boolean userCanSendFrom(Username connectedUser, Username fromUser) {
        try {
            return connectedUser.equals((Object)fromUser) || this.emailIsAnAliasOfTheConnectedUser(connectedUser, fromUser);
        }
        catch (RecipientRewriteTable.ErrorMappingException | RecipientRewriteTableException e) {
            return false;
        }
    }

    public Stream<MailAddress> allValidFromAddressesForUser(Username user) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return this.aliasReverseResolver.listAddresses(user);
    }

    private boolean emailIsAnAliasOfTheConnectedUser(Username connectedUser, Username fromUser) throws RecipientRewriteTable.ErrorMappingException, RecipientRewriteTableException {
        return fromUser.getDomainPart().isPresent() && this.recipientRewriteTable.getResolvedMappings(fromUser.getLocalPart(), (Domain)fromUser.getDomainPart().get(), ALIAS_TYPES_ACCEPTED_IN_FROM).asStream().map(Mapping::asMailAddress).flatMap(OptionalUtils::toStream).map(Username::fromMailAddress).anyMatch(alias -> alias.equals((Object)connectedUser));
    }

    @FunctionalInterface
    static interface DomainFetcher {
        public List<Domain> fetch(Username var1);
    }
}

