/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.lib;

import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.core.Username;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryManagementMBean;
import org.apache.james.user.api.model.User;

public class UsersRepositoryManagement
extends StandardMBean
implements UsersRepositoryManagementMBean {
    private UsersRepository usersRepository;

    @Inject
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public UsersRepositoryManagement() throws NotCompliantMBeanException {
        super(UsersRepositoryManagementMBean.class);
    }

    public void addUser(String rawUsername, String password) throws Exception {
        try {
            Username userName = Username.of((String)rawUsername);
            this.usersRepository.addUser(userName, password);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void deleteUser(String rawUsername) throws Exception {
        try {
            Username userName = Username.of((String)rawUsername);
            this.usersRepository.removeUser(userName);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean verifyExists(String rawUsername) throws Exception {
        try {
            Username userName = Username.of((String)rawUsername);
            return this.usersRepository.contains(userName);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public long countUsers() throws Exception {
        try {
            return this.usersRepository.countUsers();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String[] listAllUsers() throws Exception {
        ArrayList<String> userNames = new ArrayList<String>();
        try {
            Iterator it = this.usersRepository.list();
            while (it.hasNext()) {
                userNames.add(((Username)it.next()).asString());
            }
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
        return userNames.toArray(new String[userNames.size()]);
    }

    public void setPassword(String rawUsername, String password) throws Exception {
        try {
            Username userName = Username.of((String)rawUsername);
            User user = this.usersRepository.getUserByName(userName);
            if (user == null) {
                throw new UsersRepositoryException("user not found: " + userName.asString());
            }
            if (!user.setPassword(password)) {
                throw new UsersRepositoryException("Unable to update password for user " + user);
            }
            this.usersRepository.updateUser(user);
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean getVirtualHostingEnabled() throws Exception {
        try {
            return this.usersRepository.supportVirtualHosting();
        }
        catch (UsersRepositoryException e) {
            throw new Exception(e.getMessage());
        }
    }
}

