/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.managesieveserver.netty;

import javax.net.ssl.SSLEngine;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieveserver.netty.ManageSieveChannelUpstreamHandler;
import org.apache.james.managesieveserver.netty.ManageSieveServerMBean;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.lib.netty.AbstractConfigurableAsyncServer;
import org.apache.james.protocols.netty.AllButStartTlsLineChannelHandlerFactory;
import org.apache.james.protocols.netty.ChannelGroupHandler;
import org.apache.james.protocols.netty.ChannelHandlerFactory;
import org.apache.james.protocols.netty.ConnectionLimitUpstreamHandler;
import org.apache.james.protocols.netty.ConnectionPerIpLimitUpstreamHandler;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.string.StringDecoder;
import org.jboss.netty.handler.codec.string.StringEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageSieveServer
extends AbstractConfigurableAsyncServer
implements ManageSieveServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageSieveServer.class);
    static final String SSL_HANDLER = "sslHandler";
    static final String FRAMER = "framer";
    static final String CORE_HANDLER = "coreHandler";
    static final String GROUP_HANDLER = "groupHandler";
    static final String CONNECTION_LIMIT_HANDLER = "connectionLimitHandler";
    static final String CONNECTION_LIMIT_PER_IP_HANDLER = "connectionPerIpLimitHandler";
    static final String CONNECTION_COUNT_HANDLER = "connectionCountHandler";
    static final String CHUNK_WRITE_HANDLER = "chunkWriteHandler";
    static final String EXECUTION_HANDLER = "executionHandler";
    private final int maxLineLength;
    private final ManageSieveProcessor manageSieveProcessor;

    public ManageSieveServer(int maxLineLength, ManageSieveProcessor manageSieveProcessor) {
        this.maxLineLength = maxLineLength;
        this.manageSieveProcessor = manageSieveProcessor;
    }

    protected int getDefaultPort() {
        return 4190;
    }

    protected String getDefaultJMXName() {
        return "managesieveserver";
    }

    protected ChannelUpstreamHandler createCoreHandler() {
        return new ManageSieveChannelUpstreamHandler(this.manageSieveProcessor, this.getEncryption() == null ? null : this.getEncryption().getContext(), this.getEnabledCipherSuites(), this.isSSL(), LOGGER);
    }

    private boolean isSSL() {
        return this.getEncryption() != null && !this.getEncryption().isStartTLS();
    }

    protected ChannelPipelineFactory createPipelineFactory(final ChannelGroup group) {
        return new ChannelPipelineFactory(){
            private final ChannelGroupHandler groupHandler;
            {
                this.groupHandler = new ChannelGroupHandler(group);
            }

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipeline = Channels.pipeline();
                Encryption secure = ManageSieveServer.this.getEncryption();
                if (secure != null && !secure.isStartTLS()) {
                    SSLEngine engine = secure.getContext().createSSLEngine();
                    engine.setUseClientMode(false);
                    pipeline.addFirst(ManageSieveServer.SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
                }
                pipeline.addLast(ManageSieveServer.GROUP_HANDLER, (ChannelHandler)this.groupHandler);
                pipeline.addLast(ManageSieveServer.CONNECTION_LIMIT_HANDLER, (ChannelHandler)new ConnectionLimitUpstreamHandler(ManageSieveServer.this.connectionLimit));
                pipeline.addLast(ManageSieveServer.CONNECTION_LIMIT_PER_IP_HANDLER, (ChannelHandler)new ConnectionPerIpLimitUpstreamHandler(ManageSieveServer.this.connPerIP));
                pipeline.addLast(ManageSieveServer.FRAMER, ManageSieveServer.this.getFrameHandlerFactory().create(pipeline));
                pipeline.addLast(ManageSieveServer.CONNECTION_COUNT_HANDLER, (ChannelHandler)ManageSieveServer.this.getConnectionCountHandler());
                pipeline.addLast(ManageSieveServer.CHUNK_WRITE_HANDLER, (ChannelHandler)new ChunkedWriteHandler());
                ExecutionHandler ehandler = ManageSieveServer.this.getExecutionHandler();
                if (ehandler != null) {
                    pipeline.addLast(ManageSieveServer.EXECUTION_HANDLER, (ChannelHandler)ehandler);
                }
                pipeline.addLast("stringDecoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
                pipeline.addLast(ManageSieveServer.CORE_HANDLER, (ChannelHandler)ManageSieveServer.this.createCoreHandler());
                pipeline.addLast("stringEncoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
                return pipeline;
            }
        };
    }

    public String getServiceType() {
        return "Manage Sieve Service";
    }

    protected ChannelHandlerFactory createFrameHandlerFactory() {
        return new AllButStartTlsLineChannelHandlerFactory("starttls", 8192);
    }
}

