/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Optional;
import org.apache.james.queue.api.MailQueue;
import org.apache.mailet.Mail;

public interface ManageableMailQueue
extends MailQueue {
    public long getSize() throws MailQueue.MailQueueException;

    public long flush() throws MailQueue.MailQueueException;

    public long clear() throws MailQueue.MailQueueException;

    public long remove(Type var1, String var2) throws MailQueue.MailQueueException;

    public MailQueueIterator browse() throws MailQueue.MailQueueException;

    public static class MailQueueItemView {
        private final Mail mail;
        private final Optional<ZonedDateTime> nextDelivery;

        public MailQueueItemView(Mail mail) {
            this(mail, Optional.empty());
        }

        public MailQueueItemView(Mail mail, ZonedDateTime nextDelivery) {
            this(mail, Optional.of(nextDelivery));
        }

        public MailQueueItemView(Mail mail, Optional<ZonedDateTime> nextDelivery) {
            this.mail = mail;
            this.nextDelivery = nextDelivery;
        }

        public Mail getMail() {
            return this.mail;
        }

        public Optional<ZonedDateTime> getNextDelivery() {
            return this.nextDelivery;
        }
    }

    public static interface MailQueueIterator
    extends Iterator<MailQueueItemView> {
        public void close();
    }

    public static enum Type {
        Sender,
        Recipient,
        Name;

    }
}

