/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=0x7FFFFFFF)
public class BeanShellAssertion
extends BeanShellTestElement
implements Assertion {
    private static final Logger log = LoggerFactory.getLogger(BeanShellAssertion.class);
    private static final long serialVersionUID = 4L;
    public static final String FILENAME = "BeanShellAssertion.filename";
    public static final String SCRIPT = "BeanShellAssertion.query";
    public static final String PARAMETERS = "BeanShellAssertion.parameters";
    public static final String RESET_INTERPRETER = "BeanShellAssertion.resetInterpreter";
    public static final String INIT_FILE = "beanshell.assertion.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public String getScript() {
        return this.getPropertyAsString(SCRIPT);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public String getParameters() {
        return this.getPropertyAsString(PARAMETERS);
    }

    public boolean isResetInterpreter() {
        return this.getPropertyAsBoolean(RESET_INTERPRETER);
    }

    public AssertionResult getResult(SampleResult response) {
        AssertionResult result;
        block4: {
            result = new AssertionResult(this.getName());
            BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
            if (bshInterpreter == null) {
                result.setFailure(true);
                result.setError(true);
                result.setFailureMessage("BeanShell Interpreter not found");
                return result;
            }
            try {
                bshInterpreter.set("SampleResult", (Object)response);
                bshInterpreter.set("Response", (Object)response);
                bshInterpreter.set("ResponseData", (Object)response.getResponseData());
                bshInterpreter.set("ResponseCode", (Object)response.getResponseCode());
                bshInterpreter.set("ResponseMessage", (Object)response.getResponseMessage());
                bshInterpreter.set("ResponseHeaders", (Object)response.getResponseHeaders());
                bshInterpreter.set("RequestHeaders", (Object)response.getRequestHeaders());
                bshInterpreter.set("SampleLabel", (Object)response.getSampleLabel());
                bshInterpreter.set("SamplerData", (Object)response.getSamplerData());
                bshInterpreter.set("Successful", response.isSuccessful());
                bshInterpreter.set("FailureMessage", (Object)"");
                bshInterpreter.set("Failure", false);
                this.processFileOrScript(bshInterpreter);
                result.setFailureMessage(bshInterpreter.get("FailureMessage").toString());
                result.setFailure(Boolean.parseBoolean(bshInterpreter.get("Failure").toString()));
                result.setError(false);
            }
            catch (NoClassDefFoundError ex) {
                log.error("BeanShell Jar missing? " + ex.toString());
                result.setError(true);
                result.setFailureMessage("BeanShell Jar missing? " + ex.toString());
                response.setStopThread(true);
            }
            catch (Exception ex) {
                result.setError(true);
                result.setFailureMessage(ex.toString());
                if (!log.isWarnEnabled()) break block4;
                log.warn(ex.toString());
            }
        }
        return result;
    }
}

