/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.avalon.excalibur.logger.LogKitLoggerManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.NullOutputLogTarget;
import org.apache.log.output.io.WriterTarget;
import org.xml.sax.SAXException;

public final class LoggingManager {
    public static final String DEFAULT_PATTERN = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}";
    private static final String PATTERN_THREAD_PREFIX = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} %20{thread} %{category}: %{message} %{throwable}";
    private static final String PATTERN_THREAD_SUFFIX = "%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} %{category}[%{thread}]: %{message} %{throwable}";
    private static volatile PatternFormatter format = null;
    private static LogTarget target = new NullOutputLogTarget();
    private static volatile boolean isTargetSystemOut = false;
    private static volatile boolean isWriterSystemOut = false;
    public static final String LOG_FILE = "log_file";
    public static final String LOG_PRIORITY = "log_level";
    private static final String PACKAGE_PREFIX = "org.apache.";

    private LoggingManager() {
    }

    public static void initializeLogging(Properties properties) {
        LoggingManager.setFormat(properties);
        LoggingManager.setTarget(LoggingManager.makeWriter(properties.getProperty(LOG_FILE, "jmeter.log"), LOG_FILE));
        LoggingManager.setPriority(properties.getProperty(LOG_PRIORITY, "INFO"));
        LoggingManager.setLoggingLevels(properties);
        LoggingManager.setConfig(properties);
    }

    private static void setFormat(Properties properties) {
        String pattern = DEFAULT_PATTERN;
        String type = properties.getProperty("log_format_type", "");
        pattern = type.length() == 0 ? properties.getProperty("log_format", DEFAULT_PATTERN) : (type.equalsIgnoreCase("thread_suffix") ? PATTERN_THREAD_SUFFIX : (type.equalsIgnoreCase("thread_prefix") ? PATTERN_THREAD_PREFIX : DEFAULT_PATTERN));
        format = new PatternFormatter(pattern + "\n");
    }

    private static void setConfig(Properties p) {
        String cfg = p.getProperty("log_config");
        if (cfg == null) {
            return;
        }
        Hierarchy hier = Hierarchy.getDefaultHierarchy();
        LogKitLoggerManager manager = new LogKitLoggerManager(null, hier, null, null);
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        try {
            Configuration c = builder.buildFromFile(cfg);
            DefaultContext ctx = new DefaultContext();
            manager.contextualize((Context)ctx);
            manager.configure(c);
        }
        catch (IOException | IllegalArgumentException | ConfigurationException | ContextException | SAXException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println(e.toString());
        }
        catch (NullPointerException e) {
            System.out.println("Error processing logging config " + cfg);
            System.out.println("Perhaps a log target is missing?");
        }
    }

    private static PatternFormatter getFormat() {
        if (format == null) {
            format = new PatternFormatter("%{time:yyyy/MM/dd HH:mm:ss} %5.5{priority} - %{category}: %{message} %{throwable}\n");
        }
        return format;
    }

    private static Writer makeWriter(String logFile, String propName) {
        Writer wt;
        int length = logFile.split("'", -1).length;
        if (length > 1 && length % 2 == 1) {
            try {
                SimpleDateFormat df = new SimpleDateFormat(logFile);
                logFile = df.format(new Date());
            }
            catch (Exception df) {
                // empty catch block
            }
        }
        isWriterSystemOut = false;
        try {
            File logFileAsFile = new File(logFile);
            System.out.println("Writing log file to: " + logFileAsFile.getAbsolutePath());
            wt = new FileWriter(logFile);
        }
        catch (Exception e) {
            System.out.println(propName + "=" + logFile + " " + e.toString());
            System.out.println("[" + propName + "-> System.out]");
            isWriterSystemOut = true;
            wt = new PrintWriter(System.out);
        }
        return wt;
    }

    public static void setLoggingLevels(Properties appProperties) {
        for (Object o : appProperties.keySet()) {
            String category;
            String prop = (String)o;
            if (prop.startsWith("log_level.")) {
                category = prop.substring(LOG_PRIORITY.length() + 1);
                LoggingManager.setPriority(appProperties.getProperty(prop), category);
            }
            if (!prop.startsWith("log_file.")) continue;
            category = prop.substring(LOG_FILE.length() + 1);
            String file = appProperties.getProperty(prop);
            LoggingManager.setTarget((LogTarget)new WriterTarget(LoggingManager.makeWriter(file, prop), (Formatter)LoggingManager.getFormat()), category);
        }
    }

    public static String removePrefix(String name) {
        if (name.startsWith(PACKAGE_PREFIX)) {
            name = name.substring(PACKAGE_PREFIX.length());
        }
        return name;
    }

    public static Logger getLoggerForClass() {
        String className = new Exception().getStackTrace()[1].getClassName();
        return Hierarchy.getDefaultHierarchy().getLoggerFor(LoggingManager.removePrefix(className));
    }

    public static Logger getLoggerFor(String category) {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(category);
    }

    public static Logger getLoggerForShortName(String category) {
        return Hierarchy.getDefaultHierarchy().getLoggerFor(LoggingManager.removePrefix(category));
    }

    public static void setPriority(String priority, String category) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)LoggingManager.trimPriority(priority)), category);
    }

    public static void setPriorityFullName(String priority, String fullName) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)LoggingManager.trimPriority(priority)), LoggingManager.removePrefix(fullName));
    }

    public static void setPriority(Priority priority, String category) {
        Hierarchy.getDefaultHierarchy().getLoggerFor(category).setPriority(priority);
    }

    public static void setPriority(String p) {
        LoggingManager.setPriority(Priority.getPriorityForName((String)LoggingManager.trimPriority(p)));
    }

    private static final String trimPriority(String priority) {
        return priority.trim();
    }

    public static void setPriority(Priority priority) {
        Hierarchy.getDefaultHierarchy().setDefaultPriority(priority);
    }

    public static void setTarget(LogTarget target, String category) {
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(category);
        logger.setLogTargets(new LogTarget[]{target});
    }

    private static synchronized void setTarget(Writer targetFile) {
        if (target == null) {
            target = LoggingManager.getTarget(targetFile, LoggingManager.getFormat());
            isTargetSystemOut = isWriterSystemOut;
        } else {
            if (!isTargetSystemOut && target instanceof WriterTarget) {
                ((WriterTarget)target).close();
            }
            target = LoggingManager.getTarget(targetFile, LoggingManager.getFormat());
            isTargetSystemOut = isWriterSystemOut;
        }
        Hierarchy.getDefaultHierarchy().setDefaultLogTarget(target);
    }

    private static LogTarget getTarget(Writer targetFile, PatternFormatter fmt) {
        return new WriterTarget(targetFile, (Formatter)fmt);
    }

    public static void addLogTargetToRootLogger(LogTarget[] logTargets) {
        LogTarget[] newLogTargets = new LogTarget[logTargets.length + 1];
        System.arraycopy(logTargets, 0, newLogTargets, 1, logTargets.length);
        newLogTargets[0] = target;
        Hierarchy.getDefaultHierarchy().getRootLogger().setLogTargets(newLogTargets);
    }
}

