/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.json.bind.annotation.JsonbProperty;
import javax.json.bind.annotation.JsonbVisibility;
import javax.json.bind.config.PropertyVisibilityStrategy;

class DefaultPropertyVisibilityStrategy
implements PropertyVisibilityStrategy {
    private final ConcurrentMap<Class<?>, PropertyVisibilityStrategy> strategies = new ConcurrentHashMap();

    DefaultPropertyVisibilityStrategy() {
    }

    public boolean isVisible(Field field) {
        if (field.getAnnotation(JsonbProperty.class) != null) {
            return true;
        }
        PropertyVisibilityStrategy strategy = this.strategies.computeIfAbsent(field.getDeclaringClass(), this::visibilityStrategy);
        return strategy == this ? Modifier.isPublic(field.getModifiers()) : strategy.isVisible(field);
    }

    public boolean isVisible(Method method) {
        PropertyVisibilityStrategy strategy = this.strategies.computeIfAbsent(method.getDeclaringClass(), this::visibilityStrategy);
        return strategy == this ? Modifier.isPublic(method.getModifiers()) : strategy.isVisible(method);
    }

    private PropertyVisibilityStrategy visibilityStrategy(Class<?> type) {
        JsonbVisibility visibility = type.getAnnotation(JsonbVisibility.class);
        if (visibility != null) {
            try {
                return (PropertyVisibilityStrategy)visibility.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Package p = type.getPackage();
        while (p != null) {
            visibility = p.getAnnotation(JsonbVisibility.class);
            if (visibility != null) {
                try {
                    return (PropertyVisibilityStrategy)visibility.value().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String name = p.getName();
            int end = name.lastIndexOf(46);
            if (end < 0) break;
            String parentPack = name.substring(0, end);
            p = Package.getPackage(parentPack);
            if (p != null) continue;
            try {
                p = Optional.ofNullable(type.getClassLoader()).orElseGet(ClassLoader::getSystemClassLoader).loadClass(parentPack + ".package-info").getPackage();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return this;
    }
}

