/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.ValueMapper;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.ForwardingCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableProcessorSupplier;
import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.kstream.internals.TupleForwarder;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.state.KeyValueStore;

class KTableMapValues<K, V, V1>
implements KTableProcessorSupplier<K, V, V1> {
    private final KTableImpl<K, ?, V> parent;
    private final ValueMapper<? super V, ? extends V1> mapper;
    private final String queryableName;
    private boolean sendOldValues = false;

    public KTableMapValues(KTableImpl<K, ?, V> parent, ValueMapper<? super V, ? extends V1> mapper, String queryableName) {
        this.parent = parent;
        this.mapper = mapper;
        this.queryableName = queryableName;
    }

    @Override
    public Processor<K, Change<V>> get() {
        return new KTableMapValuesProcessor();
    }

    @Override
    public KTableValueGetterSupplier<K, V1> view() {
        final KTableValueGetterSupplier<K, V> parentValueGetterSupplier = this.parent.valueGetterSupplier();
        return new KTableValueGetterSupplier<K, V1>(){

            @Override
            public KTableValueGetter<K, V1> get() {
                return new KTableMapValuesValueGetter(parentValueGetterSupplier.get());
            }

            @Override
            public String[] storeNames() {
                return parentValueGetterSupplier.storeNames();
            }
        };
    }

    @Override
    public void enableSendingOldValues() {
        this.parent.enableSendingOldValues();
        this.sendOldValues = true;
    }

    private V1 computeValue(V value) {
        V1 newValue = null;
        if (value != null) {
            newValue = this.mapper.apply(value);
        }
        return newValue;
    }

    private class KTableMapValuesValueGetter
    implements KTableValueGetter<K, V1> {
        private final KTableValueGetter<K, V> parentGetter;

        public KTableMapValuesValueGetter(KTableValueGetter<K, V> parentGetter) {
            this.parentGetter = parentGetter;
        }

        @Override
        public void init(ProcessorContext context) {
            this.parentGetter.init(context);
        }

        @Override
        public V1 get(K key) {
            return KTableMapValues.this.computeValue(this.parentGetter.get(key));
        }
    }

    private class KTableMapValuesProcessor
    extends AbstractProcessor<K, Change<V>> {
        private KeyValueStore<K, V1> store;
        private TupleForwarder<K, V1> tupleForwarder;

        private KTableMapValuesProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
            super.init(context);
            if (KTableMapValues.this.queryableName != null) {
                this.store = (KeyValueStore)context.getStateStore(KTableMapValues.this.queryableName);
                this.tupleForwarder = new TupleForwarder(this.store, context, new ForwardingCacheFlushListener(context, KTableMapValues.this.sendOldValues), KTableMapValues.this.sendOldValues);
            }
        }

        @Override
        public void process(K key, Change<V> change) {
            Object oldValue;
            Object newValue = KTableMapValues.this.computeValue(change.newValue);
            Object object = oldValue = KTableMapValues.this.sendOldValues ? KTableMapValues.this.computeValue(change.oldValue) : null;
            if (KTableMapValues.this.queryableName != null) {
                this.store.put(key, newValue);
                this.tupleForwarder.maybeForward(key, newValue, oldValue);
            } else {
                this.context().forward(key, new Change<Object>(newValue, oldValue));
            }
        }
    }
}

