/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.FilteredCacheIterator;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreIterator;
import org.apache.kafka.streams.state.internals.MergedSortedCacheWindowStoreKeyValueIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.SegmentedCacheFunction;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WindowKeySchema;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingWindowStore
extends WrappedStateStore<WindowStore<Bytes, byte[]>, byte[], byte[]>
implements WindowStore<Bytes, byte[]>,
CachedStateStore<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(CachingWindowStore.class);
    private final long windowSize;
    private final SegmentedBytesStore.KeySchema keySchema = new WindowKeySchema();
    private String name;
    private ThreadCache cache;
    private boolean sendOldValues;
    private InternalProcessorContext context;
    private StateSerdes<Bytes, byte[]> bytesSerdes;
    private CacheFlushListener<byte[], byte[]> flushListener;
    private long maxObservedTimestamp;
    private final SegmentedCacheFunction cacheFunction;

    CachingWindowStore(WindowStore<Bytes, byte[]> underlying, long windowSize, long segmentInterval) {
        super(underlying);
        this.windowSize = windowSize;
        this.cacheFunction = new SegmentedCacheFunction(this.keySchema, segmentInterval);
        this.maxObservedTimestamp = -1L;
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.initInternal((InternalProcessorContext)context);
        super.init(context, root);
    }

    private void initInternal(InternalProcessorContext context) {
        this.context = context;
        String topic = ProcessorStateManager.storeChangelogTopic(context.applicationId(), this.name());
        this.bytesSerdes = new StateSerdes(topic, Serdes.Bytes(), Serdes.ByteArray());
        this.name = context.taskId() + "-" + this.name();
        this.cache = this.context.getCache();
        this.cache.addDirtyEntryFlushListener(this.name, entries -> {
            for (ThreadCache.DirtyEntry entry : entries) {
                this.putAndMaybeForward(entry, context);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext context) {
        byte[] binaryWindowKey = this.cacheFunction.key(entry.key()).get();
        Windowed<Bytes> windowedKeyBytes = WindowKeySchema.fromStoreBytesKey(binaryWindowKey, this.windowSize);
        long windowStartTimestamp = windowedKeyBytes.window().start();
        Bytes binaryKey = windowedKeyBytes.key();
        if (this.flushListener != null) {
            byte[] rawOldValue;
            byte[] rawNewValue = entry.newValue();
            byte[] byArray = rawOldValue = rawNewValue == null || this.sendOldValues ? (byte[])((WindowStore)this.wrapped()).fetch(binaryKey, windowStartTimestamp) : null;
            if (rawNewValue != null || rawOldValue != null) {
                ((WindowStore)this.wrapped()).put(binaryKey, entry.newValue(), windowStartTimestamp);
                ProcessorRecordContext current = context.recordContext();
                context.setRecordContext(entry.entry().context());
                try {
                    this.flushListener.apply(binaryWindowKey, rawNewValue, (byte[])(this.sendOldValues ? rawOldValue : null), entry.entry().context().timestamp());
                }
                finally {
                    context.setRecordContext(current);
                }
            }
        } else {
            ((WindowStore)this.wrapped()).put(binaryKey, entry.newValue(), windowStartTimestamp);
        }
    }

    @Override
    public boolean setFlushListener(CacheFlushListener<byte[], byte[]> flushListener, boolean sendOldValues) {
        this.flushListener = flushListener;
        this.sendOldValues = sendOldValues;
        return true;
    }

    @Override
    public synchronized void put(Bytes key, byte[] value) {
        this.put(key, value, this.context.timestamp());
    }

    @Override
    public synchronized void put(Bytes key, byte[] value, long windowStartTimestamp) {
        this.validateStoreOpen();
        Bytes keyBytes = WindowKeySchema.toStoreKeyBinary(key, windowStartTimestamp, 0);
        LRUCacheEntry entry = new LRUCacheEntry(value, this.context.headers(), true, this.context.offset(), this.context.timestamp(), this.context.partition(), this.context.topic());
        this.cache.put(this.name, this.cacheFunction.cacheKey(keyBytes), entry);
        this.maxObservedTimestamp = Math.max(this.keySchema.segmentTimestamp(keyBytes), this.maxObservedTimestamp);
    }

    @Override
    public byte[] fetch(Bytes key, long timestamp) {
        this.validateStoreOpen();
        Bytes bytesKey = WindowKeySchema.toStoreKeyBinary(key, timestamp, 0);
        Bytes cacheKey = this.cacheFunction.cacheKey(bytesKey);
        if (this.cache == null) {
            return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
        }
        LRUCacheEntry entry = this.cache.get(this.name, cacheKey);
        if (entry == null) {
            return (byte[])((WindowStore)this.wrapped()).fetch(key, timestamp);
        }
        return entry.value();
    }

    @Override
    public synchronized WindowStoreIterator<byte[]> fetch(Bytes key, long timeFrom, long timeTo) {
        this.validateStoreOpen();
        WindowStoreIterator<byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetch(key, timeFrom, timeTo);
        if (this.cache == null) {
            return underlyingIterator;
        }
        CacheIteratorWrapper cacheIterator = ((WindowStore)this.wrapped()).persistent() ? new CacheIteratorWrapper(key, timeFrom, timeTo) : this.cache.range(this.name, this.cacheFunction.cacheKey(this.keySchema.lowerRangeFixedSize(key, timeFrom)), this.cacheFunction.cacheKey(this.keySchema.upperRangeFixedSize(key, timeTo)));
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(key, key, timeFrom, timeTo);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheWindowStoreIterator((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)filteredCacheIterator, (KeyValueIterator<Long, byte[]>)underlyingIterator);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetch(Bytes from, Bytes to, long timeFrom, long timeTo) {
        if (from.compareTo(to) > 0) {
            LOG.warn("Returning empty iterator for fetch with invalid key range: from > to. This may be due to serdes that don't preserve ordering when lexicographically comparing the serialized bytes. Note that the built-in numerical serdes do not follow this for negative numbers");
            return KeyValueIterators.emptyIterator();
        }
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetch(from, to, timeFrom, timeTo);
        if (this.cache == null) {
            return underlyingIterator;
        }
        CacheIteratorWrapper cacheIterator = ((WindowStore)this.wrapped()).persistent() ? new CacheIteratorWrapper(from, to, timeFrom, timeTo) : this.cache.range(this.name, this.cacheFunction.cacheKey(this.keySchema.lowerRange(from, timeFrom)), this.cacheFunction.cacheKey(this.keySchema.upperRange(to, timeTo)));
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(from, to, timeFrom, timeTo);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheWindowStoreKeyValueIterator(filteredCacheIterator, underlyingIterator, this.bytesSerdes, this.windowSize, this.cacheFunction);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> fetchAll(long timeFrom, long timeTo) {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).fetchAll(timeFrom, timeTo);
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.all(this.name);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(null, null, timeFrom, timeTo);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition, this.cacheFunction);
        return new MergedSortedCacheWindowStoreKeyValueIterator(filteredCacheIterator, underlyingIterator, this.bytesSerdes, this.windowSize, this.cacheFunction);
    }

    @Override
    public KeyValueIterator<Windowed<Bytes>, byte[]> all() {
        this.validateStoreOpen();
        KeyValueIterator<Windowed<Bytes>, byte[]> underlyingIterator = ((WindowStore)this.wrapped()).all();
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.all(this.name);
        return new MergedSortedCacheWindowStoreKeyValueIterator(cacheIterator, underlyingIterator, this.bytesSerdes, this.windowSize, this.cacheFunction);
    }

    @Override
    public synchronized void flush() {
        this.cache.flush(this.name);
        ((WindowStore)this.wrapped()).flush();
    }

    @Override
    public void close() {
        this.flush();
        this.cache.close(this.name);
        ((WindowStore)this.wrapped()).close();
    }

    private class CacheIteratorWrapper
    implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
        private final long segmentInterval;
        private final Bytes keyFrom;
        private final Bytes keyTo;
        private final long timeTo;
        private long lastSegmentId;
        private long currentSegmentId;
        private Bytes cacheKeyFrom;
        private Bytes cacheKeyTo;
        private ThreadCache.MemoryLRUCacheBytesIterator current;

        private CacheIteratorWrapper(Bytes key, long timeFrom, long timeTo) {
            this(key, key, timeFrom, timeTo);
        }

        private CacheIteratorWrapper(Bytes keyFrom, Bytes keyTo, long timeFrom, long timeTo) {
            this.keyFrom = keyFrom;
            this.keyTo = keyTo;
            this.timeTo = timeTo;
            this.lastSegmentId = CachingWindowStore.this.cacheFunction.segmentId(Math.min(timeTo, CachingWindowStore.this.maxObservedTimestamp));
            this.segmentInterval = CachingWindowStore.this.cacheFunction.getSegmentInterval();
            this.currentSegmentId = CachingWindowStore.this.cacheFunction.segmentId(timeFrom);
            this.setCacheKeyRange(timeFrom, this.currentSegmentLastTime());
            this.current = CachingWindowStore.this.cache.range(CachingWindowStore.this.name, this.cacheKeyFrom, this.cacheKeyTo);
        }

        @Override
        public boolean hasNext() {
            if (this.current == null) {
                return false;
            }
            if (this.current.hasNext()) {
                return true;
            }
            while (!this.current.hasNext()) {
                this.getNextSegmentIterator();
                if (this.current != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.peekNextKey();
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.peekNext();
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current.next();
        }

        @Override
        public void close() {
            this.current.close();
        }

        private long currentSegmentBeginTime() {
            return this.currentSegmentId * this.segmentInterval;
        }

        private long currentSegmentLastTime() {
            return Math.min(this.timeTo, this.currentSegmentBeginTime() + this.segmentInterval - 1L);
        }

        private void getNextSegmentIterator() {
            ++this.currentSegmentId;
            this.lastSegmentId = CachingWindowStore.this.cacheFunction.segmentId(Math.min(this.timeTo, CachingWindowStore.this.maxObservedTimestamp));
            if (this.currentSegmentId > this.lastSegmentId) {
                this.current = null;
                return;
            }
            this.setCacheKeyRange(this.currentSegmentBeginTime(), this.currentSegmentLastTime());
            this.current.close();
            this.current = CachingWindowStore.this.cache.range(CachingWindowStore.this.name, this.cacheKeyFrom, this.cacheKeyTo);
        }

        private void setCacheKeyRange(long lowerRangeEndTime, long upperRangeEndTime) {
            if (CachingWindowStore.this.cacheFunction.segmentId(lowerRangeEndTime) != CachingWindowStore.this.cacheFunction.segmentId(upperRangeEndTime)) {
                throw new IllegalStateException("Error iterating over segments: segment interval has changed");
            }
            if (this.keyFrom == this.keyTo) {
                this.cacheKeyFrom = CachingWindowStore.this.cacheFunction.cacheKey(this.segmentLowerRangeFixedSize(this.keyFrom, lowerRangeEndTime));
                this.cacheKeyTo = CachingWindowStore.this.cacheFunction.cacheKey(this.segmentUpperRangeFixedSize(this.keyTo, upperRangeEndTime));
            } else {
                this.cacheKeyFrom = CachingWindowStore.this.cacheFunction.cacheKey(CachingWindowStore.this.keySchema.lowerRange(this.keyFrom, lowerRangeEndTime), this.currentSegmentId);
                this.cacheKeyTo = CachingWindowStore.this.cacheFunction.cacheKey(CachingWindowStore.this.keySchema.upperRange(this.keyTo, this.timeTo), this.currentSegmentId);
            }
        }

        private Bytes segmentLowerRangeFixedSize(Bytes key, long segmentBeginTime) {
            return WindowKeySchema.toStoreKeyBinary(key, Math.max(0L, segmentBeginTime), 0);
        }

        private Bytes segmentUpperRangeFixedSize(Bytes key, long segmentEndTime) {
            return WindowKeySchema.toStoreKeyBinary(key, segmentEndTime, Integer.MAX_VALUE);
        }
    }
}

