/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.ClientSensors;
import kafka.server.ConfigEntityName$;
import kafka.server.QuotaEntity;
import kafka.server.QuotaId;
import kafka.server.QuotaId$;
import kafka.server.QuotaType;
import kafka.server.QuotaTypes$;
import kafka.server.SensorAccess;
import kafka.server.ThrottledResponse;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Measurable;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Total;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichDouble$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u0001\u0003\u0001\u001d\u0011!c\u00117jK:$\u0018+^8uC6\u000bg.Y4fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!Q1A\u0005\nY\taaY8oM&<W#A\f\u0011\u0005aIR\"\u0001\u0002\n\u0005i\u0011!\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\"AA\u0004\u0001B\u0001B\u0003%q#A\u0004d_:4\u0017n\u001a\u0011\t\u0011y\u0001!Q1A\u0005\n}\tq!\\3ue&\u001c7/F\u0001!!\t\t#&D\u0001#\u0015\tq2E\u0003\u0002%K\u000511m\\7n_:T!!\u0002\u0014\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012q!T3ue&\u001c7\u000f\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003!\u0003!iW\r\u001e:jGN\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0002\u0019\u0002\r\u0005\u0004\u0018nS3z+\u0005\t\u0004C\u0001\r3\u0013\t\u0019$AA\u0005Rk>$\u0018\rV=qK\"AQ\u0007\u0001B\u0001B\u0003%\u0011'A\u0004ba&\\U-\u001f\u0011\t\u0011]\u0002!Q1A\u0005\na\nA\u0001^5nKV\t\u0011\b\u0005\u0002;y5\t1H\u0003\u0002\u0012G%\u0011Qh\u000f\u0002\u0005)&lW\r\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003:\u0003\u0015!\u0018.\\3!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003\u0019a\u0014N\\5u}Q)1\tR#G\u000fB\u0011\u0001\u0004\u0001\u0005\u0006+\u0001\u0003\ra\u0006\u0005\u0006=\u0001\u0003\r\u0001\t\u0005\u0006_\u0001\u0003\r!\r\u0005\u0006o\u0001\u0003\r!\u000f\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0003=yg/\u001a:sS\u0012$WM\\)v_R\fW#A&\u0011\t1\u001bV\u000bW\u0007\u0002\u001b*\u0011ajT\u0001\u000bG>t7-\u001e:sK:$(B\u0001)R\u0003\u0011)H/\u001b7\u000b\u0003I\u000bAA[1wC&\u0011A+\u0014\u0002\u0012\u0007>t7-\u001e:sK:$\b*Y:i\u001b\u0006\u0004\bC\u0001\rW\u0013\t9&AA\u0004Rk>$\u0018-\u00133\u0011\u0005\u0005J\u0016B\u0001.#\u0005\u0015\tVo\u001c;b\u0011\u0019a\u0006\u0001)A\u0005\u0017\u0006\u0001rN^3se&$G-\u001a8Rk>$\u0018\r\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0003e\u0019H/\u0019;jG\u000e{gNZ5h\u00072LWM\u001c;JIF+x\u000e^1\u0016\u0003aCa!\u0019\u0001!\u0002\u0013A\u0016AG:uCRL7mQ8oM&<7\t\\5f]RLE-U;pi\u0006\u0004\u0003bB2\u0001\u0001\u0004%I\u0001Z\u0001\u0012cV|G/\u0019+za\u0016\u001cXI\\1cY\u0016$W#A3\u0011\u0005%1\u0017BA4\u000b\u0005\rIe\u000e\u001e\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003U\tXo\u001c;b)f\u0004Xm]#oC\ndW\rZ0%KF$\"a\u001b8\u0011\u0005%a\u0017BA7\u000b\u0005\u0011)f.\u001b;\t\u000f=D\u0017\u0011!a\u0001K\u0006\u0019\u0001\u0010J\u0019\t\rE\u0004\u0001\u0015)\u0003f\u0003I\tXo\u001c;b)f\u0004Xm]#oC\ndW\r\u001a\u0011\t\u000fM\u0004!\u0019!C\u0005i\u0006!An\\2l+\u0005)\bC\u0001<z\u001b\u00059(B\u0001=N\u0003\u0015awnY6t\u0013\tQxO\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0011\u0019a\b\u0001)A\u0005k\u0006)An\\2lA!9a\u0010\u0001b\u0001\n\u0013y\u0018A\u00033fY\u0006L\u0018+^3vKV\u0011\u0011\u0011\u0001\t\u0006\u0019\u0006\r\u0011qA\u0005\u0004\u0003\u000bi%A\u0003#fY\u0006L\u0018+^3vKB\u0019\u0001$!\u0003\n\u0007\u0005-!AA\tUQJ|G\u000f\u001e7fIJ+7\u000f]8og\u0016D\u0001\"a\u0004\u0001A\u0003%\u0011\u0011A\u0001\fI\u0016d\u0017-_)vKV,\u0007\u0005C\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0003\u0002\u0016\u0005q1/\u001a8t_J\f5mY3tg>\u0014XCAA\f!\rA\u0012\u0011D\u0005\u0004\u00037\u0011!\u0001D*f]N|'/Q2dKN\u001c\b\u0002CA\u0010\u0001\u0001\u0006I!a\u0006\u0002\u001fM,gn]8s\u0003\u000e\u001cWm]:pe\u0002B\u0011\"a\t\u0001\u0005\u0004%\t!!\n\u0002-QD'o\u001c;uY\u0016$'+Z9vKN$(+Z1qKJ,\"!a\n\u0011\t\u0005%\u00121F\u0007\u0002\u0001\u00191\u0011Q\u0006\u0001\u0001\u0003_\u0011a\u0003\u00165s_R$H.\u001a3SKF,Xm\u001d;SK\u0006\u0004XM]\n\u0005\u0003W\t\t\u0004E\u0002\u0010\u0003gI1!!\u000e\u0011\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\t\u0015y\fYC!A!\u0002\u0013\t\t\u0001C\u0004B\u0003W!\t!a\u000f\u0015\t\u0005\u001d\u0012Q\b\u0005\b}\u0006e\u0002\u0019AA\u0001\u0011!\t\t%a\u000b\u0005B\u0005\r\u0013A\u00023p/>\u00148\u000eF\u0001l\u0011!\t9\u0005\u0001Q\u0001\n\u0005\u001d\u0012a\u0006;ie>$H\u000f\\3e%\u0016\fX/Z:u%\u0016\f\u0007/\u001a:!\u0011%\tY\u0005\u0001b\u0001\n\u0013\ti%\u0001\teK2\f\u00170U;fk\u0016\u001cVM\\:peV\u0011\u0011q\n\t\u0004C\u0005E\u0013bAA*E\t11+\u001a8t_JD\u0001\"a\u0016\u0001A\u0003%\u0011qJ\u0001\u0012I\u0016d\u0017-_)vKV,7+\u001a8t_J\u0004\u0003bBA.\u0001\u0011\u0005\u0011QL\u0001\u0017e\u0016\u001cwN\u001d3B]\u0012l\u0015-\u001f2f)\"\u0014x\u000e\u001e;mKRIQ-a\u0018\u0002r\u0005U\u0014\u0011\u0010\u0005\t\u0003C\nI\u00061\u0001\u0002d\u0005i1/\u00198ji&TX\rZ+tKJ\u0004B!!\u001a\u0002l9\u0019\u0011\"a\u001a\n\u0007\u0005%$\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\nyG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003SR\u0001\u0002CA:\u00033\u0002\r!a\u0019\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012Dq!a\u001e\u0002Z\u0001\u0007Q-A\u0003wC2,X\r\u0003\u0005\u0002|\u0005e\u0003\u0019AA?\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007#B\u0005\u0002\u0000\u0015\\\u0017bAAA\u0015\tIa)\u001e8di&|g.\r\u0005\b\u0003\u000b\u0003A\u0011BAD\u0003-\tXo\u001c;b\u000b:$\u0018\u000e^=\u0015\r\u0005%\u0015qRAI!\rA\u00121R\u0005\u0004\u0003\u001b\u0013!aC)v_R\fWI\u001c;jifD\u0001\"!\u0019\u0002\u0004\u0002\u0007\u00111\r\u0005\t\u0003g\n\u0019\t1\u0001\u0002d!9\u0011Q\u0013\u0001\u0005\n\u0005]\u0015AI9v_R\fWI\u001c;jif<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f#V|G/\u0019'fm\u0016d7\u000f\u0006\u0004\u0002\n\u0006e\u00151\u0014\u0005\t\u0003C\n\u0019\n1\u0001\u0002d!A\u00111OAJ\u0001\u0004\t\u0019\u0007C\u0004\u0002 \u0002!\t!!)\u0002\u000bE,x\u000e^1\u0015\u000ba\u000b\u0019+a*\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003G\nA!^:fe\"A\u00111OAO\u0001\u0004\t\u0019\u0007C\u0004\u0002,\u0002!I!!,\u0002\u0019QD'o\u001c;uY\u0016$\u0016.\\3\u0015\u000b\u0015\fy+!/\t\u0011\u0005E\u0016\u0011\u0016a\u0001\u0003g\u000bAb\u00197jK:$X*\u001a;sS\u000e\u00042!IA[\u0013\r\t9L\t\u0002\f\u0017\u000647.Y'fiJL7\rC\u0004\u0016\u0003S\u0003\r!a/\u0011\u0007\u0005\ni,C\u0002\u0002@\n\u0012A\"T3ue&\u001c7i\u001c8gS\u001eDq!a1\u0001\t\u0013\t)-\u0001\tnK\u0006\u001cXO]1cY\u0016\f5OU1uKR1\u0011qYAj\u0003?\u0004B!!3\u0002P6\u0011\u00111\u001a\u0006\u0004\u0003\u001b\u0014\u0013!B:uCR\u001c\u0018\u0002BAi\u0003\u0017\u0014AAU1uK\"A\u0011Q[Aa\u0001\u0004\t9.\u0001\u0003oC6,\u0007\u0003BAm\u00037l\u0011aI\u0005\u0004\u0003;\u001c#AC'fiJL7MT1nK\"A\u0011\u0011]Aa\u0001\u0004\t\u0019/\u0001\u0006nK\u0006\u001cXO]1cY\u0016\u00042!IAs\u0013\r\t9O\t\u0002\u000b\u001b\u0016\f7/\u001e:bE2,\u0007bBAv\u0001\u0011%\u0011Q^\u0001\u0018O\u0016$xJ]\"sK\u0006$X-U;pi\u0006\u001cVM\\:peN$B!a<\u0002vB\u0019\u0001$!=\n\u0007\u0005M(AA\u0007DY&,g\u000e^*f]N|'o\u001d\u0005\t\u0003\u000b\u000bI\u000f1\u0001\u0002\n\"9\u0011\u0011 \u0001\u0005\n\u0005m\u0018!G4fiRC'o\u001c;uY\u0016$\u0016.\\3TK:\u001cxN\u001d(b[\u0016$B!a\u0019\u0002~\"9\u0011q`A|\u0001\u0004)\u0016aB9v_R\f\u0017\n\u001a\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0003I9W\r^)v_R\f7+\u001a8t_Jt\u0015-\\3\u0015\t\u0005\r$q\u0001\u0005\b\u0003\u007f\u0014\t\u00011\u0001V\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\tAcZ3u#V|G/Y'fiJL7mQ8oM&<G\u0003BA^\u0005\u001fAq!a(\u0003\n\u0001\u0007\u0001\fC\u0004\u0003\u0014\u0001!\tA!\u0006\u0002\u0017U\u0004H-\u0019;f#V|G/\u0019\u000b\bW\n]!q\u0004B\u0011\u0011!\t\tG!\u0005A\u0002\te\u0001#B\u0005\u0003\u001c\u0005\r\u0014b\u0001B\u000f\u0015\t1q\n\u001d;j_:D\u0001\"a\u001d\u0003\u0012\u0001\u0007!\u0011\u0004\u0005\t\u0003?\u0013\t\u00021\u0001\u0003$A!\u0011Ba\u0007Y\u0011\u001d\u00119\u0003\u0001C\u0005\u0005S\tAc\u00197jK:$(+\u0019;f\u001b\u0016$(/[2OC6,GCBAl\u0005W\u0011i\u0003\u0003\u0005\u0002b\t\u0015\u0002\u0019AA2\u0011!\t\u0019H!\nA\u0002\u0005\r\u0004b\u0002B\u0019\u0001\u0011%!1G\u0001\u0013i\"\u0014x\u000e\u001e;mK6+GO]5d\u001d\u0006lW\r\u0006\u0003\u0002X\nU\u0002\u0002CAC\u0005_\u0001\r!!#\t\u000f\te\u0002\u0001\"\u0001\u0002D\u0005A1\u000f[;uI><h\u000e")
public class ClientQuotaManager
implements Logging {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType kafka$server$ClientQuotaManager$$apiKey;
    private final Time time;
    private final ConcurrentHashMap<QuotaId, Quota> overriddenQuota;
    private final Quota staticConfigClientIdQuota;
    private int quotaTypesEnabled;
    private final ReentrantReadWriteLock lock;
    private final DelayQueue<ThrottledResponse> delayQueue;
    private final SensorAccess sensorAccessor;
    private final ThrottledRequestReaper throttledRequestReaper;
    private final Sensor kafka$server$ClientQuotaManager$$delayQueueSensor;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientQuotaManager clientQuotaManager = this;
        synchronized (clientQuotaManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public QuotaType kafka$server$ClientQuotaManager$$apiKey() {
        return this.kafka$server$ClientQuotaManager$$apiKey;
    }

    private Time time() {
        return this.time;
    }

    private ConcurrentHashMap<QuotaId, Quota> overriddenQuota() {
        return this.overriddenQuota;
    }

    private Quota staticConfigClientIdQuota() {
        return this.staticConfigClientIdQuota;
    }

    private int quotaTypesEnabled() {
        return this.quotaTypesEnabled;
    }

    private void quotaTypesEnabled_$eq(int x$1) {
        this.quotaTypesEnabled = x$1;
    }

    private ReentrantReadWriteLock lock() {
        return this.lock;
    }

    private DelayQueue<ThrottledResponse> delayQueue() {
        return this.delayQueue;
    }

    private SensorAccess sensorAccessor() {
        return this.sensorAccessor;
    }

    public ThrottledRequestReaper throttledRequestReaper() {
        return this.throttledRequestReaper;
    }

    public Sensor kafka$server$ClientQuotaManager$$delayQueueSensor() {
        return this.kafka$server$ClientQuotaManager$$delayQueueSensor;
    }

    public int recordAndMaybeThrottle(String sanitizedUser, String clientId, int value2, Function1<Object, BoxedUnit> callback) {
        QuotaEntity clientQuotaEntity = this.kafka$server$ClientQuotaManager$$quotaEntity(sanitizedUser, clientId);
        ClientSensors clientSensors = this.getOrCreateQuotaSensors(clientQuotaEntity);
        int throttleTimeMs = 0;
        try {
            clientSensors.quotaSensor().record((double)value2);
            callback.apply$mcVI$sp(0);
        }
        catch (QuotaViolationException quotaViolationException) {
            KafkaMetric clientMetric = (KafkaMetric)this.metrics().metrics().get(this.kafka$server$ClientQuotaManager$$clientRateMetricName(clientQuotaEntity.sanitizedUser(), clientQuotaEntity.clientId()));
            throttleTimeMs = this.throttleTime(clientMetric, this.kafka$server$ClientQuotaManager$$getQuotaMetricConfig(clientQuotaEntity.quota()));
            clientSensors.throttleTimeSensor().record((double)throttleTimeMs);
            this.delayQueue().add(new ThrottledResponse(this.time(), throttleTimeMs, callback));
            this.kafka$server$ClientQuotaManager$$delayQueueSensor().record();
            this.logger().debug((Object)new StringOps(Predef$.MODULE$.augmentString("Quota violated for sensor (%s). Delay time: (%d)")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clientSensors.quotaSensor().name(), BoxesRunTime.boxToInteger((int)throttleTimeMs)})));
        }
        return throttleTimeMs;
    }

    public QuotaEntity kafka$server$ClientQuotaManager$$quotaEntity(String sanitizedUser, String clientId) {
        QuotaEntity quotaEntity;
        int n = this.quotaTypesEnabled();
        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n;
        if (bl) {
            QuotaId quotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultClientIdQuotaId())) == null) {
                quota = this.staticConfigClientIdQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, "", clientId, quota);
        } else if (QuotaTypes$.MODULE$.UserQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, "", quota);
        } else if (QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n) {
            QuotaId quotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
            Quota quota = this.overriddenQuota().get(quotaId);
            if (quota == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default())))) == null && (quota = this.overriddenQuota().get(new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId)))) == null && (quota = this.overriddenQuota().get(ClientQuotaManagerConfig$.MODULE$.DefaultUserClientIdQuotaId())) == null) {
                quota = ClientQuotaManagerConfig$.MODULE$.UnlimitedQuota();
            }
            quotaEntity = new QuotaEntity(quotaId, sanitizedUser, clientId, quota);
        } else {
            quotaEntity = this.quotaEntityWithMultipleQuotaLevels(sanitizedUser, clientId);
        }
        return quotaEntity;
    }

    private QuotaEntity quotaEntityWithMultipleQuotaLevels(String sanitizedUser, String clientId) {
        QuotaId userClientQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)clientId));
        QuotaId userQuotaId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)None$.MODULE$);
        QuotaId clientQuotaId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
        QuotaId quotaId = userClientQuotaId;
        QuotaId quotaConfigId = userClientQuotaId;
        Quota quota = this.overriddenQuota().get(quotaConfigId);
        if (quota == null) {
            quotaId = userClientQuotaId;
            quotaConfigId = new QuotaId((Option<String>)new Some((Object)sanitizedUser), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
            quota = this.overriddenQuota().get(quotaConfigId);
            if (quota == null) {
                quotaConfigId = quotaId = userQuotaId;
                quota = this.overriddenQuota().get(quotaConfigId);
                if (quota == null) {
                    quotaId = userClientQuotaId;
                    quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)clientId));
                    quota = this.overriddenQuota().get(quotaConfigId);
                    if (quota == null) {
                        quotaId = userClientQuotaId;
                        quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                        quota = this.overriddenQuota().get(quotaConfigId);
                        if (quota == null) {
                            quotaId = userQuotaId;
                            quotaConfigId = new QuotaId((Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()), (Option<String>)None$.MODULE$);
                            quota = this.overriddenQuota().get(quotaConfigId);
                            if (quota == null) {
                                quotaId = clientQuotaId;
                                quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)clientId));
                                quota = this.overriddenQuota().get(quotaConfigId);
                                if (quota == null) {
                                    quotaId = clientQuotaId;
                                    quotaConfigId = new QuotaId((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)ConfigEntityName$.MODULE$.Default()));
                                    quota = this.overriddenQuota().get(quotaConfigId);
                                    if (quota == null) {
                                        quotaId = clientQuotaId;
                                        quotaConfigId = null;
                                        quota = this.staticConfigClientIdQuota();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        QuotaId quotaId2 = quotaId;
        QuotaId quotaId3 = clientQuotaId;
        String quotaUser = !(quotaId2 != null ? !((Object)quotaId2).equals(quotaId3) : quotaId3 != null) ? "" : sanitizedUser;
        QuotaId quotaId4 = quotaId;
        QuotaId quotaId5 = userQuotaId;
        String quotaClientId = !(quotaId4 != null ? !((Object)quotaId4).equals(quotaId5) : quotaId5 != null) ? "" : clientId;
        return new QuotaEntity(quotaId, quotaUser, quotaClientId, quota);
    }

    public Quota quota(String user, String clientId) {
        return this.kafka$server$ClientQuotaManager$$quotaEntity(QuotaId$.MODULE$.sanitize(user), clientId).quota();
    }

    private int throttleTime(KafkaMetric clientMetric, MetricConfig config) {
        Rate rateMetric = this.measurableAsRate(clientMetric.metricName(), clientMetric.measurable());
        Quota quota = config.quota();
        double difference = clientMetric.value() - quota.bound();
        double throttleTimeMs = difference / quota.bound() * (double)rateMetric.windowSize(config, this.time().milliseconds());
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(throttleTimeMs));
    }

    private Rate measurableAsRate(MetricName name, Measurable measurable) {
        Measurable measurable2 = measurable;
        if (measurable2 instanceof Rate) {
            Rate rate;
            Rate rate2 = rate = (Rate)measurable2;
            return rate2;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Metric ", " is not a Rate metric, value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, measurable})));
    }

    private ClientSensors getOrCreateQuotaSensors(QuotaEntity quotaEntity) {
        return new ClientSensors(this.sensorAccessor().getOrCreate(this.getQuotaSensorName(quotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, quotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity quotaEntity$1;

            public final MetricName apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$clientRateMetricName(this.quotaEntity$1.sanitizedUser(), this.quotaEntity$1.clientId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quotaEntity$1 = quotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this, quotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity quotaEntity$1;

            public final MetricConfig apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$getQuotaMetricConfig(this.quotaEntity$1.quota());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quotaEntity$1 = quotaEntity$1;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rate apply() {
                return new Rate();
            }
        }), this.sensorAccessor().getOrCreate(this.getThrottleTimeSensorName(quotaEntity.quotaId()), ClientQuotaManagerConfig$.MODULE$.InactiveSensorExpirationTimeSeconds(), this.lock(), this.metrics(), (Function0<MetricName>)new Serializable(this, quotaEntity){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClientQuotaManager $outer;
            private final QuotaEntity quotaEntity$1;

            public final MetricName apply() {
                return this.$outer.kafka$server$ClientQuotaManager$$throttleMetricName(this.quotaEntity$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quotaEntity$1 = quotaEntity$1;
            }
        }, (Function0<MetricConfig>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Function0<MeasurableStat>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Avg apply() {
                return new Avg();
            }
        }));
    }

    private String getThrottleTimeSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$apiKey()), "ThrottleTime-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    private String getQuotaSensorName(QuotaId quotaId) {
        return new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.kafka$server$ClientQuotaManager$$apiKey()), "-")).append(quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)BoxesRunTime.boxToCharacter((char)':')).append(quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).toString();
    }

    public MetricConfig kafka$server$ClientQuotaManager$$getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config().quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config().numQuotaSamples()).quota(quota);
    }

    public void updateQuota(Option<String> sanitizedUser, Option<String> clientId, Option<Quota> quota) {
        this.lock().writeLock().lock();
        try {
            Option<String> option;
            block13: {
                Option<String> option2;
                block17: {
                    Option<Quota> option3;
                    block25: {
                        String clientIdInfo;
                        String userInfo;
                        block24: {
                            Quota quota2;
                            QuotaId quotaId;
                            block18: {
                                Tuple2 tuple2;
                                block23: {
                                    block20: {
                                        block22: {
                                            block21: {
                                                block19: {
                                                    String string;
                                                    block15: {
                                                        block16: {
                                                            Some some;
                                                            boolean bl;
                                                            block14: {
                                                                String string2;
                                                                block11: {
                                                                    block12: {
                                                                        Some some2;
                                                                        boolean bl2;
                                                                        block10: {
                                                                            quotaId = new QuotaId(sanitizedUser, clientId);
                                                                            bl2 = false;
                                                                            some2 = null;
                                                                            option = sanitizedUser;
                                                                            if (!(option instanceof Some)) break block10;
                                                                            bl2 = true;
                                                                            some2 = (Some)option;
                                                                            String string3 = (String)some2.x();
                                                                            String string4 = ConfigEntityName$.MODULE$.Default();
                                                                            String string5 = string3;
                                                                            if (string4 != null ? !string4.equals(string5) : string5 != null) break block10;
                                                                            string2 = "default user ";
                                                                            break block11;
                                                                        }
                                                                        if (!bl2) break block12;
                                                                        String user = (String)some2.x();
                                                                        string2 = new StringBuilder().append((Object)"user ").append((Object)user).append((Object)" ").toString();
                                                                        break block11;
                                                                    }
                                                                    if (!None$.MODULE$.equals(option)) break block13;
                                                                    string2 = "";
                                                                }
                                                                userInfo = string2;
                                                                bl = false;
                                                                some = null;
                                                                option2 = clientId;
                                                                if (!(option2 instanceof Some)) break block14;
                                                                bl = true;
                                                                some = (Some)option2;
                                                                String string6 = (String)some.x();
                                                                String string7 = ConfigEntityName$.MODULE$.Default();
                                                                String string8 = string6;
                                                                if (string7 != null ? !string7.equals(string8) : string8 != null) break block14;
                                                                string = "default client-id";
                                                                break block15;
                                                            }
                                                            if (!bl) break block16;
                                                            String id = (String)some.x();
                                                            string = new StringBuilder().append((Object)"client-id ").append((Object)id).toString();
                                                            break block15;
                                                        }
                                                        if (!None$.MODULE$.equals(option2)) break block17;
                                                        string = "";
                                                    }
                                                    clientIdInfo = string;
                                                    option3 = quota;
                                                    if (!(option3 instanceof Some)) break block18;
                                                    Some some = (Some)option3;
                                                    Quota newQuota = (Quota)some.x();
                                                    this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Changing ", " quota for ", "", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$apiKey(), userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                                    this.overriddenQuota().put(quotaId, newQuota);
                                                    tuple2 = new Tuple2(sanitizedUser, clientId);
                                                    if (tuple2 == null) break block19;
                                                    Option option4 = (Option)tuple2._1();
                                                    Option option5 = (Option)tuple2._2();
                                                    if (!(option4 instanceof Some) || !(option5 instanceof Some)) break block19;
                                                    this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserClientIdQuotaEnabled());
                                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                    break block20;
                                                }
                                                if (tuple2 == null) break block21;
                                                Option option6 = (Option)tuple2._1();
                                                Option option7 = (Option)tuple2._2();
                                                if (!(option6 instanceof Some) || !None$.MODULE$.equals(option7)) break block21;
                                                this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.UserQuotaEnabled());
                                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                break block20;
                                            }
                                            if (tuple2 == null) break block22;
                                            Option option8 = (Option)tuple2._1();
                                            Option option9 = (Option)tuple2._2();
                                            if (!None$.MODULE$.equals(option8) || !(option9 instanceof Some)) break block22;
                                            this.quotaTypesEnabled_$eq(this.quotaTypesEnabled() | QuotaTypes$.MODULE$.ClientIdQuotaEnabled());
                                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                            break block20;
                                        }
                                        if (tuple2 == null) break block23;
                                        Option option10 = (Option)tuple2._1();
                                        Option option11 = (Option)tuple2._2();
                                        if (!None$.MODULE$.equals(option10) || !None$.MODULE$.equals(option11)) break block23;
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                    quota2 = BoxedUnit.UNIT;
                                    break block24;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                            if (!None$.MODULE$.equals(option3)) break block25;
                            this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " quota for ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.kafka$server$ClientQuotaManager$$apiKey(), userInfo, clientIdInfo})));
                            quota2 = this.overriddenQuota().remove(quotaId);
                        }
                        MetricName quotaMetricName = this.kafka$server$ClientQuotaManager$$clientRateMetricName((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }), (String)clientId.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }));
                        Map allMetrics = this.metrics().metrics();
                        int n = this.quotaTypesEnabled();
                        boolean bl = QuotaTypes$.MODULE$.NoQuotas() == n ? true : (QuotaTypes$.MODULE$.ClientIdQuotaEnabled() == n ? true : (QuotaTypes$.MODULE$.UserQuotaEnabled() == n ? true : QuotaTypes$.MODULE$.UserClientIdQuotaEnabled() == n));
                        boolean bl3 = bl ? !sanitizedUser.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                String string = x$1;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() && !clientId.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$2) {
                                String string = x$2;
                                String string2 = ConfigEntityName$.MODULE$.Default();
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }
                        }).isDefined() : false;
                        boolean singleUpdate = bl3;
                        if (singleUpdate) {
                            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
                            if (metric != null) {
                                QuotaEntity metricConfigEntity = this.kafka$server$ClientQuotaManager$$quotaEntity((String)sanitizedUser.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }), (String)clientId.getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                }));
                                Quota newQuota = metricConfigEntity.quota();
                                this.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for ", "", " already exists. Changing quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userInfo, clientIdInfo, BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                metric.config(this.kafka$server$ClientQuotaManager$$getQuotaMetricConfig(newQuota));
                            }
                        } else {
                            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(allMetrics).asScala()).filterKeys((Function1)new Serializable(this, quotaMetricName){
                                public static final long serialVersionUID = 0L;
                                private final MetricName quotaMetricName$1;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(MetricName n) {
                                    String string = n.name();
                                    String string2 = this.quotaMetricName$1.name();
                                    if (string == null) {
                                        if (string2 != null) {
                                            return false;
                                        }
                                    } else if (!string.equals(string2)) return false;
                                    String string3 = n.group();
                                    String string4 = this.quotaMetricName$1.group();
                                    if (string3 == null) {
                                        if (string4 == null) return true;
                                        return false;
                                    } else {
                                        if (!string3.equals(string4)) return false;
                                        return true;
                                    }
                                }
                                {
                                    this.quotaMetricName$1 = quotaMetricName$1;
                                }
                            }).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ ClientQuotaManager $outer;

                                public final void apply(Tuple2<MetricName, KafkaMetric> x0$1) {
                                    Tuple2<MetricName, KafkaMetric> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        BoxedUnit boxedUnit;
                                        MetricName metricName = (MetricName)tuple2._1();
                                        KafkaMetric metric = (KafkaMetric)tuple2._2();
                                        String userTag = metricName.tags().containsKey("user") ? (String)metricName.tags().get("user") : "";
                                        String clientIdTag = metricName.tags().containsKey("client-id") ? (String)metricName.tags().get("client-id") : "";
                                        QuotaEntity metricConfigEntity = this.$outer.kafka$server$ClientQuotaManager$$quotaEntity(userTag, clientIdTag);
                                        Quota quota = metricConfigEntity.quota();
                                        Quota quota2 = metric.config().quota();
                                        if (!(quota != null ? !quota.equals(quota2) : quota2 != null)) {
                                            boxedUnit = BoxedUnit.UNIT;
                                        } else {
                                            Quota newQuota = metricConfigEntity.quota();
                                            this.$outer.logger().info((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sensor for quota-id ", " already exists. Setting quota to ", " in MetricConfig"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metricConfigEntity.quotaId(), BoxesRunTime.boxToDouble((double)newQuota.bound())})));
                                            metric.config(this.$outer.kafka$server$ClientQuotaManager$$getQuotaMetricConfig(newQuota));
                                            boxedUnit = BoxedUnit.UNIT;
                                        }
                                        BoxedUnit boxedUnit2 = boxedUnit;
                                        return;
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }
                        return;
                    }
                    throw new MatchError(option3);
                }
                throw new MatchError(option2);
            }
            throw new MatchError(option);
        }
        finally {
            this.lock().writeLock().unlock();
        }
    }

    public MetricName kafka$server$ClientQuotaManager$$clientRateMetricName(String sanitizedUser, String clientId) {
        return this.metrics().metricName("byte-rate", this.kafka$server$ClientQuotaManager$$apiKey().toString(), "Tracking byte-rate per user/client-id", new String[]{"user", sanitizedUser, "client-id", clientId});
    }

    public MetricName kafka$server$ClientQuotaManager$$throttleMetricName(QuotaEntity quotaEntity) {
        return this.metrics().metricName("throttle-time", this.kafka$server$ClientQuotaManager$$apiKey().toString(), "Tracking average throttle-time per user/client-id", new String[]{"user", quotaEntity.sanitizedUser(), "client-id", quotaEntity.clientId()});
    }

    public void shutdown() {
        this.throttledRequestReaper().shutdown();
    }

    public ClientQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, QuotaType apiKey, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.kafka$server$ClientQuotaManager$$apiKey = apiKey;
        this.time = time;
        Logging$class.$init$(this);
        this.overriddenQuota = new ConcurrentHashMap();
        this.staticConfigClientIdQuota = Quota.upperBound((double)config.quotaBytesPerSecondDefault());
        this.quotaTypesEnabled = config.quotaBytesPerSecondDefault() == Long.MAX_VALUE ? QuotaTypes$.MODULE$.NoQuotas() : QuotaTypes$.MODULE$.ClientIdQuotaEnabled();
        this.lock = new ReentrantReadWriteLock();
        this.delayQueue = new DelayQueue();
        this.sensorAccessor = new SensorAccess();
        this.throttledRequestReaper = new ThrottledRequestReaper(this, this.delayQueue());
        this.throttledRequestReaper().start();
        this.kafka$server$ClientQuotaManager$$delayQueueSensor = metrics.sensor(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)apiKey), "-delayQueue"));
        this.kafka$server$ClientQuotaManager$$delayQueueSensor().add(metrics.metricName("queue-size", apiKey.toString(), "Tracks the size of the delay queue"), (MeasurableStat)new Total());
    }

    public class ThrottledRequestReaper
    extends ShutdownableThread {
        private final DelayQueue<ThrottledResponse> delayQueue;
        public final /* synthetic */ ClientQuotaManager $outer;

        @Override
        public void doWork() {
            ThrottledResponse response = (ThrottledResponse)this.delayQueue.poll(1L, TimeUnit.SECONDS);
            if (response != null) {
                this.kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer().kafka$server$ClientQuotaManager$$delayQueueSensor().record(-1.0);
                this.trace((Function0<String>)new Serializable(this, response){
                    public static final long serialVersionUID = 0L;
                    private final ThrottledResponse response$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Response throttled for: ").append((Object)BoxesRunTime.boxToInteger((int)this.response$1.throttleTimeMs())).append((Object)" ms").toString();
                    }
                    {
                        this.response$1 = response$1;
                    }
                });
                response.execute();
            }
        }

        public /* synthetic */ ClientQuotaManager kafka$server$ClientQuotaManager$ThrottledRequestReaper$$$outer() {
            return this.$outer;
        }

        public ThrottledRequestReaper(ClientQuotaManager $outer, DelayQueue<ThrottledResponse> delayQueue) {
            this.delayQueue = delayQueue;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(new StringOps(Predef$.MODULE$.augmentString("ThrottledRequestReaper-%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$outer.kafka$server$ClientQuotaManager$$apiKey()})), false);
        }
    }
}

